/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.accounting.node.util.Util;

public class DateInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Calendar startDate = Calendar.getInstance();
    private Calendar endDate = Calendar.getInstance();
    private Long interval;

    public DateInterval(Long interval) {
        this.interval = interval;
        this.endDate = Calendar.getInstance();
        this.startDate.setTime(new Date(Calendar.getInstance().getTimeInMillis() - interval));
    }

    public DateInterval(Calendar start, Calendar end, Long interval) {
        this.endDate = end;
        this.startDate = start;
        this.interval = interval;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public Boolean contains(Date date) {
        if (this.interval.compareTo(new Long(0L)) == 0) {
            return true;
        }
        Calendar tmp = Calendar.getInstance();
        tmp.setTime(date);
        if (tmp.after(this.endDate) || tmp.before(this.startDate)) {
            return false;
        }
        return true;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public String getStartDateAsShortString() {
        return Util.format_day.format(this.startDate.getTime());
    }

    public String getStartDateAsString() {
        return Util.format.format(this.startDate.getTime());
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public String getEndDateAsString() {
        return Util.format.format(this.endDate.getTime());
    }

    public String getEndDateAsShortString() {
        return Util.format_day.format(this.endDate.getTime());
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }
}

