/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.AdvancedSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.BrowseRecord;

public class BrowseCollectionEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String browseBy;
    private boolean isDistinct;
    private HashMap<String, String> collections = null;
    private HashMap<String, String> terms = null;
    private StringTokenizer tokenizer = null;

    public BrowseCollectionEntry(String line) throws ParseException {
        this.line = line;
        this.entryType = AccessLogParser.EntryType.Browse_Collection;
        this.record = new BrowseRecord();
        this.parse();
    }

    public BaseRecord fillRecord() {
        this.collections = new HashMap();
        this.terms = new HashMap();
        this.tokenizer = new StringTokenizer(this.getMessage().getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(AdvancedSearchEntry.SearchAndBrowseTokens.collectionName.tokens)) {
                String[] col = Message.getDetails((String)tok);
                this.collections.put(col[0], col[1]);
                continue;
            }
            if (tok.contains(AdvancedSearchEntry.SearchAndBrowseTokens.term.tokens)) {
                String[] term = Message.getDetails((String)tok);
                this.terms.put(term[1], term[0]);
                continue;
            }
            if (!tok.contains(AdvancedSearchEntry.SearchAndBrowseTokens.Browse_by.tokens)) continue;
            this.browseBy = Message.getValue((String)tok);
        }
        ((BrowseRecord)this.record).setDate(this.getDate());
        ((BrowseRecord)this.record).setBrowseBy(this.browseBy);
        ((BrowseRecord)this.record).setDistinct(this.isDistinct);
        ((BrowseRecord)this.record).setCollections(this.collections);
        return this.record;
    }
}

