/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.BaseRecord;

public abstract class LogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Date date;
    protected String vre;
    protected BaseRecord record;
    protected AccessLogParser.EntryType entryType;
    protected StringTokenizer tokenizer = null;
    protected Message message;
    protected String user;
    protected String line;
    protected static final String parameterValueSeparator = "=";
    protected static final String parameterSeparator = "->";
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void parse() throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(this.line, AccessLogParser.tokensSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.contains(TokensType.ENTRY_TYPE.type)) continue;
            if (token.contains(TokensType.VRE.type)) {
                this.vre = token.substring(token.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                continue;
            }
            if (token.contains(TokensType.MESSAGE.type)) {
                if (token.indexOf(parameterSeparator) + parameterSeparator.length() == token.length()) continue;
                token = token.substring(token.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                this.message = new Message(token, this.entryType);
                this.message.parse(this);
                continue;
            }
            if (token.contains(TokensType.USER.type)) {
                this.user = token.substring(token.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                continue;
            }
            this.date = format.parse(token);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public BaseRecord getRecord() {
        return this.record;
    }

    public void setRecordName(BaseRecord record) {
        this.record = record;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getVre() {
        return this.vre;
    }

    public void setVre(String vre) {
        this.vre = vre;
    }

    public String toString() {
        return this.getVre() + parameterSeparator + this.getUser() + parameterSeparator + this.getDate() + parameterSeparator + this.getMessage();
    }

    public AccessLogParser.EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(AccessLogParser.EntryType entryType) {
        this.entryType = entryType;
    }

    public abstract BaseRecord fillRecord();
}

