/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.entry.AISEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AdvancedSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AnnotationEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AquamapsEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.BrowseCollectionEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.GenericEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.GoogleSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.HLEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LoginEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.accounting.portal.logparser.entry.QuickSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.ReportEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.RetrieveContentEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.SimpleSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.TSEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WarEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WebAppEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WorkflowDocumentEntry;

public class AccessLogParser {
    public static String tokensSeparator = ",";
    private String fileName;
    private ArrayList<LogEntry> entryList = new ArrayList();

    public AccessLogParser() {
    }

    public AccessLogParser(String string) {
        this.fileName = string;
    }

    public void parse() throws IOException, ParseException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        while ((string = bufferedReader.readLine()) != null) {
            LogEntry logEntry = this.parseLine(string);
            if (logEntry == null) continue;
            this.entryList.add(logEntry);
        }
    }

    private LogEntry parseLine(String string) throws ParseException {
        LogEntry logEntry = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, tokensSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains(EntryType.Login_To_VRE.type)) {
                logEntry = new LoginEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Generic_Entry.type)) {
                logEntry = new GenericEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Simple_Search.type)) {
                logEntry = new SimpleSearchEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Advanced_Search.type)) {
                logEntry = new AdvancedSearchEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Browse_Collection.type)) {
                logEntry = new BrowseCollectionEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Retrieve_Content.type)) {
                logEntry = new RetrieveContentEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Quick_Search.type)) {
                logEntry = new QuickSearchEntry(string);
                continue;
            }
            if (string2.contains(EntryType.Google_Search.type)) {
                logEntry = new GoogleSearchEntry(string);
                continue;
            }
            if (string2.contains(EntryType.HL_BASKET_ITEM_CREATED.type)) {
                logEntry = new HLEntry(string, EntryType.HL_BASKET_ITEM_CREATED);
                continue;
            }
            if (string2.contains(EntryType.HL_BASKET_ITEM_REMOVED.type)) {
                logEntry = new HLEntry(string, EntryType.HL_BASKET_ITEM_REMOVED);
                continue;
            }
            if (string2.contains(EntryType.HL_BASKET_ITEM_IMPORTED.type)) {
                logEntry = new HLEntry(string, EntryType.HL_BASKET_ITEM_IMPORTED);
                continue;
            }
            if (string2.contains(EntryType.HL_ITEM_SENT.type)) {
                logEntry = new HLEntry(string, EntryType.HL_ITEM_SENT);
                continue;
            }
            if (string2.contains(EntryType.HL_WORKSPACEAREA_CREATED.type)) {
                logEntry = new HLEntry(string, EntryType.HL_WORKSPACEAREA_CREATED);
                continue;
            }
            if (string2.contains(EntryType.TS_CSV_IMPORTED.type)) {
                logEntry = new TSEntry(string, EntryType.TS_CSV_IMPORTED);
                continue;
            }
            if (string2.contains(EntryType.TS_CURATION_STARTED.type)) {
                logEntry = new TSEntry(string, EntryType.TS_CURATION_STARTED);
                continue;
            }
            if (string2.contains(EntryType.TS_CURATION_CLOSED.type)) {
                logEntry = new TSEntry(string, EntryType.TS_CURATION_CLOSED);
                continue;
            }
            if (string2.contains(EntryType.TS_TIMESERIES_SAVED.type)) {
                logEntry = new TSEntry(string, EntryType.TS_TIMESERIES_SAVED);
                continue;
            }
            if (string2.contains(EntryType.TS_TIMESERIES_PUBLISHED.type)) {
                logEntry = new TSEntry(string, EntryType.TS_TIMESERIES_PUBLISHED);
                continue;
            }
            if (string2.contains(EntryType.SCRIPT_CREATED.type)) {
                logEntry = new AISEntry(string, EntryType.SCRIPT_CREATED);
                continue;
            }
            if (string2.contains(EntryType.SCRIPT_REMOVED.type)) {
                logEntry = new AISEntry(string, EntryType.SCRIPT_REMOVED);
                continue;
            }
            if (string2.contains(EntryType.SCRIPT_LAUNCHED.type)) {
                logEntry = new AISEntry(string, EntryType.SCRIPT_LAUNCHED);
                continue;
            }
            if (string2.contains(EntryType.Create_Annotation.type)) {
                logEntry = new AnnotationEntry(string, EntryType.Create_Annotation);
                continue;
            }
            if (string2.contains(EntryType.Edit_Annotation.type)) {
                logEntry = new AnnotationEntry(string, EntryType.Edit_Annotation);
                continue;
            }
            if (string2.contains(EntryType.Delete_Annotation.type)) {
                logEntry = new AnnotationEntry(string, EntryType.Delete_Annotation);
                continue;
            }
            if (string2.contains(EntryType.CREATED_WORKFLOWREPORT_OUTPUT.type)) {
                logEntry = new WorkflowDocumentEntry(string, EntryType.CREATED_WORKFLOWREPORT_OUTPUT);
                continue;
            }
            if (string2.contains(EntryType.DELETED_WORKFLOWREPORT_OUTPUT.type)) {
                logEntry = new WorkflowDocumentEntry(string, EntryType.DELETED_WORKFLOWREPORT_OUTPUT);
                continue;
            }
            if (string2.contains(EntryType.CREATE_REPORT.type)) {
                logEntry = new ReportEntry(string, EntryType.CREATE_REPORT);
                continue;
            }
            if (string2.contains(EntryType.GENERATE_REPORT_OUTPUT.type)) {
                logEntry = new ReportEntry(string, EntryType.GENERATE_REPORT_OUTPUT);
                continue;
            }
            if (string2.contains(EntryType.OPEN_REPORT.type)) {
                logEntry = new ReportEntry(string, EntryType.OPEN_REPORT);
                continue;
            }
            if (string2.contains(EntryType.OPEN_WORKFLOW_REPORT.type)) {
                logEntry = new ReportEntry(string, EntryType.OPEN_WORKFLOW_REPORT);
                continue;
            }
            if (string2.contains(EntryType.SAVE_WORKFLOW_REPORT.type)) {
                logEntry = new ReportEntry(string, EntryType.SAVE_WORKFLOW_REPORT);
                continue;
            }
            if (string2.contains(EntryType.CREATE_TEMPLATE.type)) {
                logEntry = new ReportEntry(string, EntryType.CREATE_TEMPLATE);
                continue;
            }
            if (string2.contains(EntryType.OPEN_TEMPLATE.type)) {
                logEntry = new ReportEntry(string, EntryType.OPEN_TEMPLATE);
                continue;
            }
            if (string2.contains(EntryType.WEB_APPLICATION_DEPLOYED.type)) {
                logEntry = new WebAppEntry(string, EntryType.WEB_APPLICATION_DEPLOYED);
                continue;
            }
            if (string2.contains(EntryType.WEB_APPLICATION_ACTIVATED.type)) {
                logEntry = new WebAppEntry(string, EntryType.WEB_APPLICATION_ACTIVATED);
                continue;
            }
            if (string2.contains(EntryType.WEB_APPLICATION_DEACTIVATED.type)) {
                logEntry = new WebAppEntry(string, EntryType.WEB_APPLICATION_DEACTIVATED);
                continue;
            }
            if (string2.contains(EntryType.WEB_APPLICATION_UNDEPLOYED.type)) {
                logEntry = new WebAppEntry(string, EntryType.WEB_APPLICATION_UNDEPLOYED);
                continue;
            }
            if (string2.contains(EntryType.WAR_REMOVED.type)) {
                logEntry = new WarEntry(string, EntryType.WAR_REMOVED);
                continue;
            }
            if (string2.contains(EntryType.WAR_UPDATED.type)) {
                logEntry = new WarEntry(string, EntryType.WAR_UPDATED);
                continue;
            }
            if (string2.contains(EntryType.WAR_UPLOADED.type)) {
                logEntry = new WarEntry(string, EntryType.WAR_UPLOADED);
                continue;
            }
            if (string2.contains(EntryType.AQUAMAPSOBJECTGENERATION.type)) {
                logEntry = new AquamapsEntry(string, EntryType.AQUAMAPSOBJECTGENERATION);
                continue;
            }
            if (!string2.contains(EntryType.AQUAMAPSSAVEDITEM.type)) continue;
            logEntry = new AquamapsEntry(string, EntryType.AQUAMAPSSAVEDITEM);
        }
        return logEntry;
    }

    public static void main(String[] stringArray) {
        AccessLogParser accessLogParser = new AccessLogParser(stringArray[0]);
        ArrayList<Object> arrayList = new ArrayList();
        try {
            accessLogParser.parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        arrayList = accessLogParser.getEntryList();
        for (LogEntry logEntry : arrayList) {
            if (!(logEntry instanceof AdvancedSearchEntry)) continue;
            Message message = logEntry.getMessage();
            for (String string : logEntry.getMessage().getCollections().values()) {
                System.out.println(string);
            }
            for (String string : logEntry.getMessage().getTerms().values()) {
                System.out.println(string);
            }
        }
    }

    public ArrayList<LogEntry> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(ArrayList<LogEntry> arrayList) {
        this.entryList = arrayList;
    }

    public static enum EntryType {
        Login_To_VRE("Login_To_VRE"),
        Generic_Entry("Generic_Entry"),
        Simple_Search("Simple_Search"),
        Advanced_Search("Advanced_Search"),
        Browse_Collection("Browse_Collection"),
        Retrieve_Content("Retrieve_Content"),
        Quick_Search("Quick_Search"),
        Google_Search("Google_Search"),
        HL_BASKET_ITEM_CREATED("HL_BASKET_ITEM_CREATED"),
        HL_BASKET_ITEM_REMOVED("HL_BASKET_ITEM_REMOVED"),
        HL_BASKET_ITEM_IMPORTED("HL_BASKET_ITEM_IMPORTED"),
        HL_ITEM_SENT("HL_ITEM_SENT"),
        HL_WORKSPACEAREA_CREATED("HL_WORKSPACEAREA_CREATED"),
        SCRIPT_CREATED("SCRIPT_CREATED"),
        SCRIPT_REMOVED("SCRIPT_REMOVED"),
        SCRIPT_LAUNCHED("SCRIPT_LAUNCHED"),
        TS_CSV_IMPORTED("TS_CSV_IMPORTED"),
        TS_CURATION_STARTED("TS_CURATION_STARTED"),
        TS_CURATION_CLOSED("TS_CURATION_CLOSED"),
        TS_TIMESERIES_SAVED("TS_TIMESERIES_SAVED"),
        TS_TIMESERIES_PUBLISHED("TS_TIMESERIES_PUBLISHED"),
        Create_Annotation("Create_Annotation"),
        Edit_Annotation("Edit_Annotation"),
        Delete_Annotation("Delete_Annotation"),
        CREATED_WORKFLOWREPORT_OUTPUT("Created_WorkflowReport_Output"),
        DELETED_WORKFLOWREPORT_OUTPUT("Deleted_WorkflowReport_Output"),
        CREATE_REPORT("Create_Report"),
        GENERATE_REPORT_OUTPUT("Generate_Report_Output"),
        OPEN_REPORT("Open_Report"),
        OPEN_WORKFLOW_REPORT("Open_Workflow_Report"),
        SAVE_WORKFLOW_REPORT("SaveWorkflowLogEntry"),
        CREATE_TEMPLATE("Create_Template"),
        OPEN_TEMPLATE("Open_Template"),
        WEB_APPLICATION_DEPLOYED("WEB_APPLICATION_DEPLOYED"),
        WEB_APPLICATION_ACTIVATED("WEB_APPLICATION_ACTIVATED"),
        WEB_APPLICATION_DEACTIVATED("WEB_APPLICATION_DEACTIVATED"),
        WEB_APPLICATION_UNDEPLOYED("WEB_APPLICATION_UNDEPLOYED"),
        WAR_UPLOADED("WAR_UPLOADED"),
        WAR_UPDATED("WAR_UPDATED"),
        WAR_REMOVED("WAR_REMOVED"),
        AQUAMAPSOBJECTGENERATION("AquaMapsObjectGenerationLogEntry"),
        AQUAMAPSSAVEDITEM("SavedAquaMapsItemLogEntry");

        String type;

        private EntryType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

