/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.probes;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.messaging.common.producer.GCUBELocalProducer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseFilters {
    public static String defaultFiltersLocation = System.getenv("CATALINA_HOME") + File.separator + "shared" + File.separator + "d4s" + File.separator + "bannedList.xml";
    private String filtersLocation = "";
    private Document domDocument = null;
    private ArrayList<String> containsFilter = new ArrayList();
    private ArrayList<String> equalsFilter = new ArrayList();

    public ParseFilters() throws Exception {
        this.filtersLocation = defaultFiltersLocation;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.domDocument = documentBuilder.parse(new File(this.filtersLocation));
            this.parse();
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)exception);
            throw exception;
        }
    }

    private void parse() throws Exception {
        Element element = this.domDocument.getDocumentElement();
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                if (((Element)node).getTagName().compareTo("Contains") == 0) {
                    GCUBELocalProducer.logger.debug((Object)("Found Contains filter: " + node.getTextContent().trim()));
                    this.containsFilter.add(node.getTextContent().trim());
                    continue;
                }
                if (((Element)node).getTagName().compareTo("Equal") != 0) continue;
                GCUBELocalProducer.logger.debug((Object)("Found Equal filter: " + node.getTextContent().trim()));
                this.equalsFilter.add(node.getTextContent().trim());
            }
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)exception);
            throw exception;
        }
    }

    public boolean applyFilters(String string) {
        for (String string2 : this.containsFilter) {
            if (!string.contains(string2)) continue;
            return true;
        }
        for (String string2 : this.equalsFilter) {
            if (string.compareTo(string2) != 0) continue;
            return true;
        }
        return false;
    }
}

