/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.messaging.common.messages.MessageField;
import org.gcube.messaging.common.messages.SystemAccountingMessage;
import org.gcube.messaging.common.messages.util.SQLType;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class SystemAccounting {
    protected SystemAccounting() throws IOException, GCUBEScopeNotSupportedException {
        if (this.isClientMode()) {
            this.startLocalProducer(GCUBEScope.getScope((String)("/" + GHNContext.getContext().getProperty("infrastructure", new boolean[]{true}))));
        }
    }

    public void sendSystemAccountingMessage(GCUBEServiceContext gCUBEServiceContext, String string, HashMap<String, Object> hashMap, GCUBEScope ... gCUBEScopeArray) throws GHNClientModeException, SystemAccountingMessage.ReservedFieldException, IllegalArgumentException, Exception {
        if (this.isClientMode()) {
            throw new GHNClientModeException("Container is not running, this method is not intented to be used in GHN client mode");
        }
        SystemAccountingMessage systemAccountingMessage = new SystemAccountingMessage();
        try {
            systemAccountingMessage.setMessageType(string);
            systemAccountingMessage.setServiceClass(gCUBEServiceContext.getServiceClass());
            systemAccountingMessage.setServiceName(gCUBEServiceContext.getName());
            systemAccountingMessage.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
            systemAccountingMessage.setTimeNow();
            for (String string2 : hashMap.keySet()) {
                MessageField messageField = new MessageField();
                messageField.setName(string2);
                messageField.setValue(hashMap.get(string2));
                messageField.setSqlType(SQLType.getSQLType((Object)hashMap.get(string2)));
                systemAccountingMessage.addField(messageField);
            }
            if (gCUBEScopeArray.length > 0) {
                hashMap.put("callerScope", gCUBEScopeArray[0].toString());
                systemAccountingMessage.createTopicName(gCUBEScopeArray[0].getInfrastructure());
                systemAccountingMessage.setScope(gCUBEScopeArray[0].getInfrastructure().toString());
                GCUBELocalProducer.logger.debug((Object)systemAccountingMessage.toString());
                systemAccountingMessage.checkReservedField();
                this.sendMessage((GCUBEMessage)systemAccountingMessage);
            } else {
                for (String string2 : gCUBEServiceContext.getInstance().getScopes().values()) {
                    hashMap.put("callerScope", string2.toString());
                    systemAccountingMessage.createTopicName(string2.getInfrastructure());
                    systemAccountingMessage.setScope(string2.getInfrastructure().toString());
                    GCUBELocalProducer.logger.debug((Object)systemAccountingMessage.toString());
                    systemAccountingMessage.checkReservedField();
                    this.sendMessage((GCUBEMessage)systemAccountingMessage);
                }
            }
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)"Error Sending System accounting message", (Throwable)exception);
            exception.printStackTrace();
            throw exception;
        }
    }

    public void sendSystemAccountingMessage(String string, GCUBEScope gCUBEScope, String string2, HashMap<String, Object> hashMap) throws GCUBEScopeNotSupportedException, SystemAccountingMessage.ReservedFieldException, IllegalArgumentException, Exception {
        SystemAccountingMessage systemAccountingMessage = new SystemAccountingMessage();
        systemAccountingMessage.setMessageType(string);
        systemAccountingMessage.setScope(gCUBEScope.toString());
        systemAccountingMessage.setSourceGHN(string2);
        systemAccountingMessage.setTimeNow();
        systemAccountingMessage.createTopicName(gCUBEScope);
        for (String string3 : hashMap.keySet()) {
            MessageField messageField = new MessageField();
            messageField.setName(string3);
            messageField.setValue(hashMap.get(string3));
            messageField.setSqlType(SQLType.getSQLType((Object)hashMap.get(string3)));
            systemAccountingMessage.addField(messageField);
        }
        GCUBELocalProducer.logger.debug((Object)systemAccountingMessage.toString());
        systemAccountingMessage.checkReservedField();
        this.sendMessage((GCUBEMessage)systemAccountingMessage);
    }

    private boolean isClientMode() {
        return GHNContext.getContext().isClientMode();
    }

    private void sendMessage(GCUBEMessage gCUBEMessage) {
        ActiveMQClient.getSingleton().sendMessageToQueue(gCUBEMessage);
    }

    private void startLocalProducer(GCUBEScope gCUBEScope) throws GCUBEScopeNotSupportedException {
        GCUBELocalProducer gCUBELocalProducer = new GCUBELocalProducer();
        long l = 1200L;
        ArrayList<EndpointReferenceType> arrayList = new ArrayList<EndpointReferenceType>();
        if (gCUBEScope.getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
            for (EndpointReferenceType endpointReferenceType : gCUBEScope.getServiceMap().getEndpoints((Object)"MessageBroker")) {
                arrayList.add(endpointReferenceType);
            }
        }
        HashMap<GCUBEScope, ArrayList<EndpointReferenceType>> hashMap = new HashMap<GCUBEScope, ArrayList<EndpointReferenceType>>();
        hashMap.put(gCUBEScope, arrayList);
        gCUBELocalProducer.setBrokerMap((HashMap)hashMap);
        gCUBELocalProducer.setInterval(l);
        gCUBELocalProducer.run();
    }

    class GHNClientModeException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public GHNClientModeException(String string) {
            super(string);
        }
    }
}

