/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.messaging.common.messages.GCUBEMessage;
import org.gcube.messaging.common.messages.MessageField;
import org.gcube.messaging.common.messages.SystemAccountingMessage;
import org.gcube.messaging.common.messages.util.SQLType;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAccounting {
    private static Logger logger = LoggerFactory.getLogger(SystemAccounting.class);

    protected SystemAccounting() throws IOException, GCUBEScopeNotSupportedException {
        if (this.isClientMode()) {
            this.startLocalProducer(GCUBEScope.getScope((String)("/" + GHNContext.getContext().getProperty("infrastructure", new boolean[]{true}))));
        }
    }

    public void sendSystemAccountingMessage(GCUBEServiceContext context, String type, HashMap<String, Object> parameters, GCUBEScope ... scope) throws GHNClientModeException, SystemAccountingMessage.ReservedFieldException, IllegalArgumentException, Exception {
        if (this.isClientMode()) {
            throw new GHNClientModeException("Container is not running, this method is not intented to be used in GHN client mode");
        }
        SystemAccountingMessage message = new SystemAccountingMessage();
        try {
            message.setMessageType(type);
            message.setServiceClass(context.getServiceClass());
            message.setServiceName(context.getName());
            message.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
            message.setTimeNow();
            for (String key : parameters.keySet()) {
                MessageField field = new MessageField();
                field.setName(key);
                field.setValue(parameters.get(key));
                field.setSqlType(SQLType.getSQLType((Object)parameters.get(key)));
                message.addField(field);
            }
            if (scope.length > 0) {
                parameters.put("callerScope", scope[0].toString());
                message.createTopicName(scope[0].getInfrastructure().toString());
                message.setScope(scope[0].getInfrastructure().toString());
                logger.debug(message.toString());
                message.checkReservedField();
                this.sendMessage((GCUBEMessage)message);
            } else {
                for (GCUBEScope sco : context.getInstance().getScopes().values()) {
                    parameters.put("callerScope", sco.toString());
                    message.createTopicName(sco.getInfrastructure().toString());
                    message.setScope(sco.getInfrastructure().toString());
                    logger.debug(message.toString());
                    message.checkReservedField();
                    this.sendMessage((GCUBEMessage)message);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error Sending System accounting message", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public void sendSystemAccountingMessage(String type, GCUBEScope scope, String sourceGHN, HashMap<String, Object> parameters) throws GCUBEScopeNotSupportedException, SystemAccountingMessage.ReservedFieldException, IllegalArgumentException, Exception {
        SystemAccountingMessage message = new SystemAccountingMessage();
        message.setMessageType(type);
        message.setScope(scope.toString());
        message.setSourceGHN(sourceGHN);
        message.setTimeNow();
        message.createTopicName(scope.toString());
        for (String key : parameters.keySet()) {
            MessageField field = new MessageField();
            field.setName(key);
            field.setValue(parameters.get(key));
            field.setSqlType(SQLType.getSQLType((Object)parameters.get(key)));
            message.addField(field);
        }
        logger.debug(message.toString());
        message.checkReservedField();
        this.sendMessage((GCUBEMessage)message);
    }

    private boolean isClientMode() {
        return GHNContext.getContext().isClientMode();
    }

    private void sendMessage(GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessageToQueue(message);
    }

    private void startLocalProducer(GCUBEScope scope) throws GCUBEScopeNotSupportedException {
        GCUBELocalProducer local = new GCUBELocalProducer();
        long interval = 1200L;
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        if (scope.getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
            for (EndpointReferenceType msgBrokerEpr : scope.getServiceMap().getEndpoints((Object)"MessageBroker")) {
                eprs.add(msgBrokerEpr);
            }
        }
        HashMap<GCUBEScope, ArrayList<EndpointReferenceType>> monitoredScopes = new HashMap<GCUBEScope, ArrayList<EndpointReferenceType>>();
        monitoredScopes.put(scope, eprs);
        local.setBrokerMap(monitoredScopes);
        local.setInterval(interval);
        local.run();
    }

    class GHNClientModeException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public GHNClientModeException(String string) {
            super(string);
        }
    }
}

