/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;

public class NotificationQuery
extends Query<ConsumerCL> {
    private static final long serialVersionUID = 1L;

    @Override
    protected String performQuery() throws Exception {
        this.logger.debug((Object)this.getQuery());
        Long startTime = System.currentTimeMillis();
        String result = this.call.queryMonitoringDB(this.getQuery());
        Long endTime = System.currentTimeMillis();
        this.logger.debug((Object)("Query time = " + (endTime - startTime) + " ms"));
        return result;
    }

    public HashMap<String, ArrayList<String>> getNotificationList() throws Exception {
        HashMap<String, ArrayList<String>> hash = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT testType, testSubType FROM NOTIFICATION ORDER BY testType");
        try {
            this.query();
            JSONArray tmp = this.toJSON();
            for (int i = 0; i < tmp.length(); ++i) {
                String type = tmp.getJSONObject(i).getString("testType");
                String subtype = tmp.getJSONObject(i).getString("testSubType");
                ArrayList<String> list = null;
                list = hash.get(type);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(subtype);
                hash.put(type, list);
            }
        }
        catch (JSONException e) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(e);
        }
        catch (EmptyResultException e) {
            this.logger.error((Object)"Error executing query");
            throw e;
        }
        catch (QueryNotSetException e) {
            this.logger.error((Object)"Error executing query");
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error executing query");
            throw e;
        }
        return hash;
    }

    public String getStatistics(String testType, String GHNName, String startDate, String endDate, String groupBy) throws Exception {
        this.setQuery("SELECT COUNT(*) AS CNT, " + groupBy + " FROM NOTIFICATION " + "WHERE date >= '" + startDate + "' AND date <= '" + endDate + "' " + (testType.compareTo("") == 0 ? "" : " AND testSubType='" + testType + "'") + (GHNName.compareTo("") == 0 ? "" : " AND GHNName='" + GHNName + "'") + " GROUP BY " + groupBy);
        try {
            this.query();
        }
        catch (JSONException e) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(e);
        }
        catch (EmptyResultException e) {
            this.logger.error((Object)"Error executing query");
            throw e;
        }
        return this.getResults();
    }
}

