package org.gcube.messaging.common.consumerlibrary.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.proxies.Proxies;
import org.gcube.messaging.common.consumerlibrary.query.AccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.MonitoringQuery;
import org.gcube.messaging.common.consumerlibrary.query.NodeAccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.PortalAccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.NodeAccountingQuery.InvocationInfo;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.messages.Test.TestType;
import org.gcube.messaging.common.messages.records.AdvancedSearchRecord;
import org.gcube.messaging.common.messages.records.BrowseRecord;
import org.gcube.messaging.common.messages.records.GoogleSearchRecord;
import org.gcube.messaging.common.messages.records.LoginRecord;
import org.gcube.messaging.common.messages.records.QuickSearchRecord;
import org.gcube.messaging.common.messages.records.SimpleSearchRecord;

/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
@SuppressWarnings("unused")
public class ConsumerLibrary {

	private GCUBESecurityManager secMan= new GCUBESecurityManagerImpl(){	public boolean isSecurityEnabled() {return false;}};	

	private ConsumerCL call= null;
	
	public GCUBELog logger= new GCUBELog(this.getClass());

	/**
	 * Creates a consumer Library to query a Consumer Service on the given scope
	 * @param scope the scope 
	 * @throws Exception exception
	 */
	public ConsumerLibrary (GCUBEScope scope) throws Exception {
		ScopeProvider.instance.set(scope.toString());
		this.call = Proxies.consumerService().withTimeout(1, TimeUnit.MINUTES).build();
		}

	/**
	 * Creates a consumer Library to query the given instance of Consumer Service
	 * 
	 * @param scope Consumer service scope
	 * @param endpoint endpoint
	 * @param port port
	 * @throws Exception  Exception
	 */
	public ConsumerLibrary (GCUBEScope scope,String endpoint, String port) throws Exception {
		ScopeProvider.instance.set(scope.toString());
		this.call = Proxies.consumerService().at(endpoint, Integer.parseInt(port)).withTimeout(1, TimeUnit.MINUTES).build();
		}


	/**
	 * Returns a query from the interface or class which defines its type.
	 * The method is intended as a means to bind query interfaces to concrete implementations provided
	 * along with implementations of this interface.
	 * @param <QUERY> the type of the query which produces results 
	 * @param type the query interface or class.
	 * @return the query.
	 * @throws IllegalAccessException  IllegalAccessException
	 * @throws InstantiationException  IllegalAccessException
	 */
	public <QUERY extends Query<ConsumerCL>> QUERY getQuery(Class<QUERY> type) throws InstantiationException, IllegalAccessException {
		QUERY query= type.newInstance();
		query.setCall(call);
		return query;
	}

}
