/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;

public class SystemAccountingQuery
extends Query<ConsumerCL> {
    private static final long serialVersionUID = 1L;

    @Override
    public String performQuery() throws Exception {
        this.logger.debug(this.getQuery());
        Long startTime = System.currentTimeMillis();
        String result = this.call.querySystemAccountingDB(this.getQuery());
        Long endTime = System.currentTimeMillis();
        this.logger.debug("Query time = " + (endTime - startTime) + " ms");
        return result;
    }

    public ArrayList<String> getTypes() throws QueryNotSetException, Exception {
        this.setQuery("SHOW TABLES");
        this.query();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        for (ArrayList<String> list : this.getResultsAsArray()) {
            if (i == 0) {
                ++i;
                continue;
            }
            results.add(list.get(0));
        }
        return results;
    }

    public ArrayList<ArrayList<String>> getTypeContent(String name) throws QueryNotSetException, Exception {
        this.getTypeContentAsJSONString(name);
        return this.getResultsAsArray();
    }

    public String getTypeContentAsJSONString(String name) throws QueryNotSetException, Exception {
        this.setQuery("SELECT * FROM " + name);
        return this.query();
    }

    public JSONArray getTypeContentAsJSONObject(String name) throws QueryNotSetException, Exception {
        this.setQuery("SELECT * FROM " + name);
        this.query();
        return this.toJSON();
    }

    public String queryTypeContentAsJSONString(String query) throws QueryNotSetException, Exception {
        this.setQuery(query);
        return this.query();
    }

    public JSONArray queryTypeContentAsJSONObject(String query) throws QueryNotSetException, Exception {
        this.setQuery(query);
        this.query();
        return this.toJSON();
    }
}

