/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.json.JSONObject;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Query<CALL extends ConsumerCL>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected CALL call;
    protected String results;
    protected String query = null;
    protected String orderClause = "";
    protected String limitClause = "";
    protected String groupClause = "";
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected abstract String performQuery() throws Exception;

    public String query() throws Exception, QueryNotSetException {
        if (this.query == null) {
            throw new QueryNotSetException();
        }
        this.checkQuery(this.getQuery());
        this.setResults(this.performQuery());
        return this.getResults();
    }

    private void checkQuery(String query) throws Exception {
        if (!query.startsWith("SELECT") && !query.startsWith("SHOW")) {
            throw new Exception("The query MUST be a SELECT/SHOW statement");
        }
    }

    public JSONArray toJSON() throws EmptyResultException {
        try {
            return new JSONObject(this.getResults()).getJSONArray("data");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new EmptyResultException();
        }
    }

    public Long getDimensions(String tableName) throws Exception {
        this.setQuery("SELECT COUNT(*) AS COUNT FROM " + tableName);
        String json = this.performQuery();
        return Long.valueOf((String)new JSONObject(json).getJSONArray("data").getJSONObject(0).get("COUNT"));
    }

    public void printQueryResults() throws Exception {
        for (int k = 0; k < this.toJSON().getJSONObject(0).names().length(); ++k) {
            this.logger.debug(this.toJSON().getJSONObject(0).names().get(k).toString());
        }
        for (int i = 0; i < this.toJSON().length(); ++i) {
            for (int j = 0; j < this.toJSON().getJSONObject(i).names().length(); ++j) {
                this.logger.debug(this.toJSON().getJSONObject(i).get(this.toJSON().getJSONObject(i).names().getString(j)).toString());
            }
            this.logger.debug("");
        }
    }

    public CALL getCall() {
        return this.call;
    }

    public void setCall(CALL call) {
        this.call = call;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public String getQuery() {
        return this.query + this.getGroupClause() + this.getOrderClause() + this.getLimitClause();
    }

    public void setQuery(String query) {
        this.results = null;
        this.query = query;
    }

    public String getOrderClause() {
        return this.orderClause;
    }

    public void setOrderClause(String order) {
        this.orderClause = " ORDER BY " + order;
    }

    public String getLimitClause() {
        return this.limitClause;
    }

    public void setLimitClause(Integer start, Integer limit) {
        this.limitClause = " LIMIT " + start.toString() + "," + limit.toString();
    }

    public void setLimitClause(Integer limit) {
        this.limitClause = " LIMIT " + limit.toString();
    }

    public String getGroupClause() {
        return this.groupClause;
    }

    public void setGroupClause(String group) {
        this.groupClause = " GROUP BY " + group;
    }

    public ArrayList<ArrayList<String>> getResultsAsArray() throws Exception {
        ArrayList<ArrayList<String>> results = new ArrayList<ArrayList<String>>();
        try {
            ArrayList<String> names = new ArrayList<String>();
            JSONArray tmp = this.toJSON();
            for (int k = 0; k < tmp.getJSONObject(0).names().length(); ++k) {
                names.add((String)tmp.getJSONObject(0).names().get(k));
            }
            results.add(names);
            for (int i = 0; i < tmp.length(); ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < tmp.getJSONObject(i).names().length(); ++j) {
                    row.add((String)tmp.getJSONObject(i).get(tmp.getJSONObject(i).names().getString(j)));
                }
                results.add(row);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return results;
    }
}

