/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.query.AccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;

public class NodeAccountingQuery
extends AccountingQuery {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long serialVersionUID = 1L;

    public InvocationInfo getInvocationPerInterval(String string, String string2, String string3, String string4, String string5, GCUBEScope ... gCUBEScopeArray) throws Exception {
        InvocationInfo invocationInfo = new InvocationInfo();
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE FROM NODEACCOUNTING WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND startDate >= '" + string4 + "' AND endDate <= '" + string5 + "' " + "AND GHNName='" + string3 + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            this.logger.debug((Object)this.toJSON());
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("SUMINVOCATION"));
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVERAGE"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    public InvocationInfo getInvocationPerInterval(String string, String string2, String string3, String string4, GCUBEScope ... gCUBEScopeArray) throws Exception {
        InvocationInfo invocationInfo = new InvocationInfo();
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE FROM NODEACCOUNTING WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND startDate >= '" + string3 + "' AND endDate <= '" + string4 + "' " + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            this.logger.debug((Object)this.toJSON());
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("SUMINVOCATION"));
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVERAGE"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    public String getInvocationPerInterval(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE, " + string7 + " FROM NODEACCOUNTING " + "WHERE startDate >= '" + string4 + "' AND endDate <= '" + string5 + "' " + (string.compareTo("") == 0 ? "" : " AND ServiceClass='" + string + "'") + (string2.compareTo("") == 0 ? "" : " AND ServiceName='" + string2 + "'") + (string3.compareTo("") == 0 ? "" : " AND GHNName='" + string3 + "'") + (string6.compareTo("") == 0 ? "" : " AND callerScope='" + string6 + "'") + " GROUP BY " + string7);
        try {
            this.query();
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return this.getResults();
    }

    public InvocationInfo getInvocationPerHour(String string, String string2, GCUBEScope ... gCUBEScopeArray) throws Exception {
        InvocationInfo invocationInfo = new InvocationInfo();
        Date date = format.parse(string);
        Date date2 = format.parse(string2);
        long l = date2.getTime() - date.getTime();
        long l2 = l / 3600000L;
        this.logger.debug((Object)("Intervals = " + l2));
        this.setQuery("SELECT COUNT(DISTINCT GHNName) FROM NODEACCOUNTING WHERE startDate >= '" + string + "' AND endDate <= '" + string2 + "' " + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        Long l3 = Long.valueOf(this.getResultsAsArray().get(1).get(0));
        this.logger.debug((Object)("numner of nodes: " + l3));
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE FROM NODEACCOUNTING WHERE startDate >= '" + string + "' AND endDate <= '" + string2 + "' " + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("SUMINVOCATION") / (double)l2 / (double)l3.longValue());
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVERAGE"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    @Deprecated
    public InvocationInfo getHourlyInvocations(String string, String string2, String string3, String string4, String string5, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        InvocationInfo invocationInfo = new InvocationInfo();
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND date='" + string4 + "' AND timeframe='" + string5 + "' " + "AND GHNName='" + string3 + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("SUMINVOCATION"));
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVERAGE"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    @Deprecated
    public Integer getSumInvocations(String string, String string2, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        Integer n = null;
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            n = this.toJSON().getJSONObject(0).getInt("SUMINVOCATION");
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return n;
    }

    @Deprecated
    public InvocationInfo getAverageHourlyInvocationInfo(String string, String string2, String[] stringArray, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        InvocationInfo invocationInfo = new InvocationInfo();
        this.setQuery("SELECT AVG(invocationNumber) AS AVGINV, AVG(averageInvocationTime) AS AVGTIME FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND date BETWEEN '" + stringArray[0] + "' AND '" + stringArray[1] + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("AVGINV"));
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVGTIME"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    @Deprecated
    public Long getAverageHourlyInvocations(String string, String string2, String[] stringArray, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        Long l = null;
        this.setQuery("SELECT AVG(invocationNumber) AS AVG FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND date BETWEEN '" + stringArray[0] + "' AND '" + stringArray[1] + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            l = this.toJSON().getJSONObject(0).getLong("AVG");
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return l;
    }

    @Deprecated
    public InvocationInfo getDailyInvocations(String string, String string2, String string3, String string4, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        InvocationInfo invocationInfo = new InvocationInfo();
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND date='" + string4 + "' " + "AND GHNName='" + string3 + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : ""));
        try {
            this.query();
            invocationInfo.setInvocationCount(this.toJSON().getJSONObject(0).getDouble("SUMINVOCATION"));
            invocationInfo.setAvgInvocationTime(this.toJSON().getJSONObject(0).getDouble("AVERAGE"));
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return invocationInfo;
    }

    @Deprecated
    public ArrayList<InvocationInfo> getDailyInvocationsGroupByIp(String string, String string2, String string3, String string4, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        ArrayList<InvocationInfo> arrayList = new ArrayList<InvocationInfo>();
        this.setQuery("SELECT SUM(invocationNumber) AS SUMINVOCATION, AVG(averageInvocationTime) AS AVERAGE, callerIP FROM NODEINVOCATION WHERE ServiceClass='" + string + "' AND ServiceName='" + string2 + "' AND date='" + string4 + "' " + "AND GHNName='" + string3 + "'" + (gCUBEScopeArray.length > 0 ? " AND callerScope='" + gCUBEScopeArray[0].toString() + "'" : "") + " GROUP BY callerIP");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                InvocationInfo invocationInfo = new InvocationInfo();
                invocationInfo.setInvocationCount(jSONArray.getJSONObject(i).getDouble("SUMINVOCATION"));
                invocationInfo.setAvgInvocationTime(jSONArray.getJSONObject(i).getDouble("AVERAGE"));
                invocationInfo.setIP(jSONArray.getJSONObject(i).getString("callerIP"));
                arrayList.add(invocationInfo);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return arrayList;
    }

    public Map<String, ArrayList<String>> getServices() throws Exception {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT ServiceClass, ServiceName  FROM NODEACCOUNTING ORDER BY ServiceClass");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string = jSONArray.getJSONObject(i).getString("ServiceClass");
                ArrayList<String> arrayList = null;
                arrayList = (ArrayList<String>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(jSONArray.getJSONObject(i).getString("ServiceName"));
                hashMap.put(string, arrayList);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (QueryNotSetException queryNotSetException) {
            this.logger.error((Object)"Error executing query");
            throw queryNotSetException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return hashMap;
    }

    public Map<String, ArrayList<String>> getGHNs() throws Exception {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT GHNName  FROM NODEACCOUNTING ORDER BY GHNname");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string = jSONArray.getJSONObject(i).getString("GHNName");
                String string2 = string.substring(string.indexOf(".") + 1);
                String string3 = string2.substring(0, string2.indexOf(":"));
                ArrayList<String> arrayList = null;
                arrayList = (ArrayList<String>)hashMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
                hashMap.put(string3, arrayList);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (QueryNotSetException queryNotSetException) {
            this.logger.error((Object)"Error executing query");
            throw queryNotSetException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return hashMap;
    }

    public ArrayList<ArrayList<String>> getScopes() throws Exception {
        this.setQuery("SELECT DISTINCT callerScope FROM NODEACCOUNTING ORDER BY callerScope");
        this.query();
        return this.getResultsAsArray();
    }

    public class InvocationInfo {
        Double invocationCount;
        Double avgInvocationTime;
        String IP;

        public String getIP() {
            return this.IP;
        }

        public void setIP(String string) {
            this.IP = string;
        }

        public Double getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(Double d) {
            this.invocationCount = d;
        }

        public Double getAvgInvocationTime() {
            return this.avgInvocationTime;
        }

        public void setAvgInvocationTime(Double d) {
            this.avgInvocationTime = d;
        }
    }
}

