/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.ri;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.consumer.Constants;
import org.gcube.messaging.common.consumer.MessageChecker;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.ri.RINotification;
import org.gcube.messaging.common.messages.RIMessage;
import org.gcube.messaging.common.messages.Test;

public class RIMessageChecker
extends MessageChecker<RIMessage<?>> {
    public RIMessageChecker(GCUBEScope scope) {
        super(scope);
    }

    @Override
    public void check(RIMessage<?> message) {
        if (!message.getTopic().contains("RI")) {
            return;
        }
        RINotification not = new RINotification();
        not.setType(message.getTest().getType().toString());
        not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get(message.getTest().getType().name()).replace(Constants.MailTemplateToken.INFO.toString(), message.getTest().getDescription()));
        not.setServiceClass(message.getServiceClass());
        not.setServiceName(message.getServiceName());
        not.setSourceGHN(message.getSourceGHN());
        not.setScope(GCUBEScope.getScope((String)message.getScope()));
        not.setTime(message.getTime());
        switch (message.getTest().getType()) {
            case NOTIFICATION: {
                if (message.getTest().getPriority().compareTo((Enum)Test.Priority.HIGH) != 0) break;
                ServiceContext.getContext().getNotifier().enqueue(not);
                ServiceContext.getContext().getMonitoringManager().insertNotification(not);
                break;
            }
        }
        ServiceContext.getContext().getMonitoringManager().InsertRIMessage(message);
    }
}

