/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.db.PoolManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DBManager {
    GCUBELog logger = new GCUBELog(DBManager.class);
    protected Connection connection;
    protected static File backupFolder = null;
    protected String dbFileBaseFolder;
    protected String dbFileName;
    protected String dbName;
    protected String username = ServiceContext.getContext().getDbuser();
    protected String password = ServiceContext.getContext().getDbpass();
    protected File queriesFile;
    protected PoolManager poolManager = null;
    protected static int backupIntervalMS = 3600000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("scheduledBackupInHours", new boolean[]{true}));

    public abstract void open() throws ClassNotFoundException, SQLException, Exception;

    public synchronized void close() throws Exception {
        try {
            if (this.connection == null) {
                this.reconnectToDB();
            }
            if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
                this.connection.createStatement().execute("SHUTDOWN");
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.connection.close();
        }
    }

    public synchronized void backup() throws SQLException, Exception {
        if (this.connection == null) {
            this.reconnectToDB();
        }
        this.connection.createStatement().execute("CHECKPOINT");
        backupFolder.mkdirs();
        new Thread(){

            @Override
            public void run() {
                try {
                    DBManager.this.zipFolder(new File(DBManager.this.dbFileBaseFolder).listFiles());
                }
                catch (Exception e) {
                    DBManager.this.logger.error((Object)"Error creating a backup for the DB", (Throwable)e);
                }
            }
        }.start();
    }

    public synchronized void queryAndConsume(String expression, BaseConsumer consumer) throws SQLException, Exception {
        Statement statement = null;
        try {
            if (this.connection == null) {
                this.reconnectToDB();
            }
            statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(expression);
            consumer.consume(resultSet);
        }
        catch (Exception e) {
            this.reconnectToDB();
            throw e;
        }
    }

    public synchronized ResultSet query(String expression) throws SQLException, Exception {
        Statement statement = null;
        try {
            if (this.connection == null) {
                this.reconnectToDB();
            }
            statement = this.connection.createStatement();
            return statement.executeQuery(expression);
        }
        catch (Exception e) {
            this.reconnectToDB();
            throw e;
        }
    }

    public synchronized String queryJSON(String expression) throws SQLException, Exception {
        try (Statement statement = null;){
            if (this.connection == null) {
                this.reconnectToDB();
            }
            statement = this.connection.createStatement();
            String string = DBManager.toJSon(statement.executeQuery(expression));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(String expression) throws Exception {
        try (Statement statement = null;){
            if (this.connection == null) {
                this.reconnectToDB();
            }
            statement = this.connection.createStatement();
            statement.executeUpdate(expression);
        }
    }

    protected void createDB() throws SQLException, Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document domDocument = null;
        builder = factory.newDocumentBuilder();
        domDocument = builder.parse(this.queriesFile);
        Element root = domDocument.getDocumentElement();
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String expression;
            Node node = nodeList.item(i);
            if (node.getFirstChild() == null || (expression = node.getFirstChild().getNodeValue().trim()).compareTo("") == 0) continue;
            this.logger.debug((Object)("Executing update query n. " + i + "\nThe query is '" + expression + "'"));
            this.update(expression);
            this.logger.debug((Object)("Query: '" + expression + "' executed successfully"));
        }
        this.logger.info((Object)"DB created successfully");
    }

    public static String toJSon(ResultSet resultSet) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int row = 0;
        while (resultSet.next()) {
            if (row > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            for (int column = 1; column <= numberOfColumns; ++column) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(DBManager.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(DBManager.quote(resultSet.getString(column)));
            }
            json.append('}');
            ++row;
        }
        json.append("],\"total_count\":");
        json.append(row);
        json.append("}");
        return json.toString();
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    protected void zipFolder(File[] files) throws Exception {
        byte[] buf = new byte[1024];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
        String outFilename = backupFolder + File.separator + dateFormat.format(new Date().getTime()) + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
        for (int i = 0; i < files.length; ++i) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry(files[i].getAbsolutePath()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        this.logger.debug((Object)("DB Backup created @ " + outFilename));
    }

    protected abstract void connectToMySql() throws Exception;

    protected void connectToEmbeddedDB() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        this.connection = DriverManager.getConnection("jdbc:hsqldb:" + this.dbFileName, this.username, this.password);
        this.connection.setAutoCommit(true);
    }

    protected void reconnectToDB() throws Exception {
        if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
            this.connectToEmbeddedDB();
        } else {
            this.connectToMySql();
        }
    }

    public static interface BaseConsumer {
        public void consume(ResultSet var1) throws Exception;
    }
}

