/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.messages;

import java.lang.reflect.Field;
import java.util.TreeMap;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.MessageField;
import org.gcube.messaging.common.messages.Test;

public class SystemAccountingMessage
extends GCUBEMessage {
    private static final long serialVersionUID = 1L;
    private String serviceClass;
    private String serviceName;
    private String messageType;
    private TreeMap<String, MessageField> fieldMap = new TreeMap();
    public static final String systemAccounting = "ACCOUNTING.SYSTEM";

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String string) {
        this.serviceClass = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public TreeMap<String, MessageField> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(TreeMap<String, MessageField> treeMap) {
        this.fieldMap = treeMap;
    }

    public synchronized void addField(MessageField messageField) {
        this.fieldMap.put(messageField.getName(), messageField);
    }

    public void createTopicName(GCUBEScope gCUBEScope) {
        if (gCUBEScope.isInfrastructure()) {
            this.topic = Test.replaceUnderscore(gCUBEScope.getInfrastructure().getName()) + "." + systemAccounting + "." + Test.replaceUnderscore(this.sourceGHN);
        } else if (gCUBEScope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String string = gCUBEScope.getName();
            this.topic = Test.replaceUnderscore(gCUBEScope.getInfrastructure().getName()) + "." + Test.replaceUnderscore(string) + "." + systemAccounting + "." + Test.replaceUnderscore(this.sourceGHN);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.messageType + "\t");
        stringBuilder.append(this.scope + "\t");
        stringBuilder.append(this.serviceClass + "\t");
        stringBuilder.append(this.serviceName + "\t");
        stringBuilder.append(this.sourceGHN + "\t");
        stringBuilder.append(this.time + "\t");
        stringBuilder.append(this.topic + "\t");
        for (MessageField messageField : this.fieldMap.values()) {
            stringBuilder.append(messageField.getName() + "\t");
            stringBuilder.append(messageField.getValue() + "\t");
            stringBuilder.append(messageField.getSqlType() + "\t");
        }
        return stringBuilder.toString();
    }

    public void checkReservedField() throws ReservedFieldException {
        Field[] fieldArray = ((Object)((Object)this)).getClass().getDeclaredFields();
        Field[] fieldArray2 = GCUBEMessage.class.getDeclaredFields();
        for (Field field : fieldArray) {
            if (!this.fieldMap.containsKey(field.getName())) continue;
            throw new ReservedFieldException("The parameters name " + field.getName() + " is already used by the application");
        }
        for (Field field : fieldArray2) {
            if (!this.fieldMap.containsKey(field.getName())) continue;
            throw new ReservedFieldException("The parameters name " + field.getName() + " is already used by the application");
        }
        if (this.fieldMap.containsKey("id")) {
            throw new ReservedFieldException("The parameters name id is already used by the application");
        }
    }

    public class ReservedFieldException
    extends Exception {
        private static final long serialVersionUID = 2107643850291448530L;

        public ReservedFieldException(String string) {
            super(string);
        }
    }
}

