package org.gcube.messaging.common.messages;

import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * Model a RunningInstance Message
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class RIMessage<TEST extends Test> extends GCUBEMessage{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * topic base
	 */
	public static final String RI="MONITORING.RI";

	public RIMessage(){};

	private TEST test;

	private String serviceName;
	private String serviceClass;

	/**
	 * get the serviceName
	 * @return the serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * set the service name
	 * @param serviceName
	 */
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	/**
	 * get the service class
	 * @return the service class
	 */
	public String getServiceClass() {
		return serviceClass;
	}

	/**
	 * set the service class
	 * @param serviceClass the service class
	 */
	public void setServiceClass(String serviceClass) {
		this.serviceClass = serviceClass;
	}

	/**
	 * get the test Object
	 * @return  the test ojbect
	 */
	public TEST getTest() {
		return test;
	}

	/**
	 * set the test object
	 * @param test the test object
	 */
	public void setTest(TEST test) {
		this.test = test;
	}

	/**
	 * create a RIMessage for the given scope and ghn
	 * @param ghnName the ghn
	 * @param VO the scope
	 */
	public RIMessage(String ghnName, GCUBEScope VO){
		this.sourceGHN = ghnName;
		this.topic = createTopicName(ghnName, VO);
		this.scope= VO.toString();
	}


	/**
	 * to string
	 */
	public String toString() {
		return this.sourceGHN +"/"+this.serviceClass +"/"+this.serviceName +"/"+ this.time +"/" + this.test.toString()+"/"+this.topic+"/"+this.scope; 
	}

	private String createTopicName(String ghnName, GCUBEScope scope) {
		if (scope.isInfrastructure()){
			return Test.replaceUnderscore(scope.getInfrastructure().getName())+
			"."+RIMessage.RI +
			"."+Test.replaceUnderscore(ghnName);
		}
		else if (scope.getType().compareTo(GCUBEScope.Type.VO) == 0)
		{
			String voName =scope.getName();
			return Test.replaceUnderscore(scope.getInfrastructure().getName())+
			"."+Test.replaceUnderscore(voName)+
			"."+RIMessage.RI +
			"."+Test.replaceUnderscore(ghnName);
		}
		else return null;

	}
}
