/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.messages;

import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.Test;

public class GHNMessage<TEST extends Test>
extends GCUBEMessage {
    private static final long serialVersionUID = 1L;
    public static final String GHN = "MONITORING.GHN";
    private TEST test;

    public GHNMessage() {
    }

    public TEST getTest() {
        return this.test;
    }

    public void setTest(TEST test) {
        this.test = test;
    }

    public GHNMessage(String ghnName, GCUBEScope VO) {
        this.sourceGHN = ghnName;
        this.topic = this.createTopicName(ghnName, VO);
        this.scope = VO.toString();
    }

    public String toString() {
        return this.sourceGHN + "/" + this.time + "/" + ((Test)this.test).toString() + "/" + this.topic + "/" + this.scope;
    }

    private String createTopicName(String ghnName, GCUBEScope scope) {
        if (scope.isInfrastructure()) {
            return Test.replaceUnderscore(scope.getInfrastructure().getName()) + "." + GHN + "." + Test.replaceUnderscore(ghnName);
        }
        if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String voName = scope.getName();
            return Test.replaceUnderscore(scope.getInfrastructure().getName()) + "." + Test.replaceUnderscore(voName) + "." + GHN + "." + Test.replaceUnderscore(ghnName);
        }
        return null;
    }
}

