package org.gcube.messaging.common.messages;

import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * Models a GHN Message
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class GHNMessage<TEST extends Test> extends GCUBEMessage{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * topic base
	 */
	public static final String GHN="MONITORING.GHN";

	public GHNMessage(){};

	private TEST test;

	/**
	 * get the test contained into the message
	 * @return the test
	 */
	public TEST getTest() {
		return test;
	}

	/**
	 * set the test object for this message
	 * @param test the test
	 */
	public void setTest(TEST test) {
		this.test = test;
	}


	/**
	 * build a new GHNMessage 
	 * @param ghnName the ghnname
	 * @param VO the vo
	 */
	public GHNMessage(String ghnName, GCUBEScope VO){
		this.sourceGHN = ghnName;
		this.topic = createTopicName(ghnName, VO);
		this.scope= VO.toString();
	}


	/**
	 * String representation
	 */
	public String toString() {
		return this.sourceGHN +"/"+ this.time +"/" + this.test.toString()+"/"+this.topic+"/"+this.scope; 
	}

	private String createTopicName(String ghnName, GCUBEScope scope) {
		if (scope.isInfrastructure()){
			return Test.replaceUnderscore(scope.getInfrastructure().getName())+
			"."+GHNMessage.GHN+
			"."+Test.replaceUnderscore(ghnName);
		}
		else if (scope.getType().compareTo(GCUBEScope.Type.VO) == 0)
		{
			String voName =scope.getName();
			return Test.replaceUnderscore(scope.getInfrastructure().getName())+
			"."+Test.replaceUnderscore(voName)+
			"."+GHNMessage.GHN+
			"."+Test.replaceUnderscore(ghnName);
		}
		else return null;

	}
}
