package org.gcube.messaging.monitoring.probes.ghn;

import java.util.Map;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.messages.Test;


/**
 * Check the GHN CPU Load
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class GHNLoadProbe extends GHNProbe{


	/**
	 * Default Constructor
	 */
	public GHNLoadProbe(){}


	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.utils.handlers.GCUBEHandler#run()
	 */
	@Override
	public void run() throws Exception {
		Test test = new Test();
		try {
			Map<String,Double> load =  GHNContext.getContext().getLoadStatistics();
        	test.setDescription("Check the CPU load statistic over the last 15 mins");
        	test.setType(Test.TestType.CPU_LOAD);
        	test.setTestNumber(Integer.valueOf(number++));
        	test.setTestResult(new Double(load.get("15mins")));
        	sendMessageWithTest(test);
		}catch (Exception e){
			logger.error("Error getting CPU Load",e);
		} 
		
		
	}

}

