/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.opensearch.client.factory;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.opensearch.client.exception.OpenSearchClientException;
import org.gcube.rest.opensearch.client.inject.OpenSearchClientModule;
import org.gcube.rest.opensearch.common.apis.OpenSearchServiceFactoryAPI;
import org.gcube.rest.opensearch.common.discover.OpenSearchDiscovererAPI;
import org.gcube.rest.opensearch.common.entities.Provider;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchFactoryClient {
    private static Gson gson = new Gson();
    private InformationCollector icollector;
    private String endpoint;
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchFactoryClient.class);

    public OpenSearchFactoryClient(Builder builder) throws OpenSearchClientException {
        this.endpoint = builder.endpoint;
        this.icollector = builder.icollector;
        OpenSearchDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null || this.icollector == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new OpenSearchClientModule()});
            if (discoverer == null) {
                discoverer = (OpenSearchDiscovererAPI)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<OpenSearchDiscovererAPI<OpenSearchDataSourceResource>>(){}));
            }
            if (this.icollector == null) {
                this.icollector = (InformationCollector)injector.getInstance(InformationCollector.class);
            }
        }
        this.initialize((OpenSearchDiscovererAPI<OpenSearchDataSourceResource>)discoverer, builder.scope);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void initialize(OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer, String scope) throws OpenSearchClientException {
        try {
            Set opensearchNodes = discoverer.discoverOpenSearchInstances(scope);
            ArrayList endpoints = Lists.newArrayList((Iterable)opensearchNodes);
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new OpenSearchClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            this.endpoint = (String)endpoints.get(0);
            logger.info("Initialized at : " + this.endpoint);
            return;
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new OpenSearchClientException("could not initialize random client", e);
        }
    }

    public String createResource(List<String> fields, List<Provider> providers, String scope) throws OpenSearchClientException {
        logger.info("calling createResourcee with parameters. scope : " + scope);
        OpenSearchDataSourceResource resource = new OpenSearchDataSourceResource();
        if (scope != null) {
            resource.setScope(scope);
        }
        ArrayList openSearchResourceIDs = Lists.newArrayList();
        ArrayList collectionIDs = Lists.newArrayList();
        ArrayList fixedParameters = Lists.newArrayList();
        for (Provider provider : providers) {
            openSearchResourceIDs.add(provider.getOpenSearchResourceID());
            collectionIDs.add(provider.getCollectionID());
            OpenSearchDataSourceResource.FixedParam fp = new OpenSearchDataSourceResource.FixedParam();
            fp.setParams((List)Lists.newArrayList((Iterable)provider.getFixedParameters()));
            fixedParameters.add(fp);
        }
        List<String> genericResources = OpenSearchFactoryClient.getOpenSearchGenericResources(this.icollector, openSearchResourceIDs, scope);
        resource.setOpenSearchResourceXML(genericResources);
        resource.setOpenSearchResource((List)openSearchResourceIDs);
        resource.setCollectionID((List)collectionIDs);
        resource.setFixedParameters((List)fixedParameters);
        resource.setFields(fields);
        String json = resource.toJSON();
        logger.info("calling create resource with json params : " + json);
        Response response = null;
        response = OpenSearchFactoryClient.getOpenSearchServiceFactoryProxy(this.endpoint).createResourceREST(scope, json);
        logger.info("createResource returned");
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            throw new OpenSearchClientException("resource could not be created : " + error);
        }
        String responseJSON = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(responseJSON, new TypeToken<Map<String, String>>(){}.getType());
        logger.info("Created resource with id : " + (String)resp.get("resourceID"));
        String resourceID = (String)resp.get("resourceID");
        return resourceID;
    }

    private static OpenSearchServiceFactoryAPI getOpenSearchServiceFactoryProxy(String endpoint) throws OpenSearchClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        OpenSearchServiceFactoryAPI simple = null;
        logger.info("getting proxy from opensearch factory service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (OpenSearchServiceFactoryAPI)target.proxy(OpenSearchServiceFactoryAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new OpenSearchClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from opensearch factory service...OK");
        return simple;
    }

    public static List<String> getOpenSearchGenericResources(InformationCollector icollector, List<String> resourceIDs, String scope) {
        ArrayList openSearchResourcesString = Lists.newArrayList();
        for (String resourceID : resourceIDs) {
            List resources = icollector.getGenericResourcesByID(resourceID, scope);
            if (resources == null || resources.size() <= 0) continue;
            try {
                String resourceBody = ((Resource)resources.get(0)).getBodyAsString();
                if (resourceBody == null) continue;
                openSearchResourcesString.add(resourceBody);
            }
            catch (Exception e) {
                logger.warn("error reading the body for resource with id : " + resourceID, (Throwable)e);
            }
        }
        return openSearchResourcesString;
    }

    public static class Builder {
        private String endpoint;
        private String scope;
        private final OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer;
        private final InformationCollector icollector;

        public Builder() {
            this.discoverer = null;
            this.icollector = null;
        }

        @Inject
        public Builder(OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer, InformationCollector icollector) {
            this.discoverer = discoverer;
            this.icollector = icollector;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OpenSearchFactoryClient build() throws OpenSearchClientException {
            return new OpenSearchFactoryClient(this);
        }
    }
}

