/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.cacherefresh;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResource;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResourceHome;
import org.gcube.opensearch.opensearchdatasource.StatefulContext;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.queryelements.BasicQueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.BasicURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.globus.wsrf.ResourceKey;

public class CacheRefresher
implements Runnable {
    private static GCUBELog logger = new GCUBELog(CacheRefresher.class);
    private long lastRefresh;
    private long refreshIntervalMillis;
    private long cycleCount;
    private boolean forceRefresh;
    private Object synchMe = null;

    public CacheRefresher(long refreshIntervalMillis) {
        if (refreshIntervalMillis < 0L) {
            throw new IllegalArgumentException("Negative time interval value");
        }
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.cycleCount = 1L;
        this.synchMe = new Object();
        this.forceRefresh = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastRefresh = Calendar.getInstance().getTimeInMillis();
        long millisSinceLastRefresh = 0L;
        long nextRefresh = this.refreshIntervalMillis;
        while (true) {
            int refreshCount = 0;
            int failed = 0;
            if (this.refreshIntervalMillis != 0L) {
                logger.debug((Object)("Next cache refresh in " + (nextRefresh - millisSinceLastRefresh) + " milliseconds"));
            } else {
                millisSinceLastRefresh = Integer.MIN_VALUE;
            }
            boolean explicitRefreshRequested = false;
            while (millisSinceLastRefresh < nextRefresh) {
                Object object = this.synchMe;
                synchronized (object) {
                    try {
                        if (this.refreshIntervalMillis != 0L) {
                            this.synchMe.wait(nextRefresh - millisSinceLastRefresh);
                        } else {
                            this.synchMe.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.forceRefresh) {
                        this.forceRefresh = false;
                        explicitRefreshRequested = true;
                        millisSinceLastRefresh = Calendar.getInstance().getTimeInMillis() - this.lastRefresh;
                        nextRefresh = this.refreshIntervalMillis - millisSinceLastRefresh;
                        break;
                    }
                }
                if (this.refreshIntervalMillis == 0L) continue;
                millisSinceLastRefresh = Calendar.getInstance().getTimeInMillis() - this.lastRefresh;
            }
            if (!explicitRefreshRequested) {
                nextRefresh = this.refreshIntervalMillis;
                this.lastRefresh = Calendar.getInstance().getTimeInMillis();
                logger.debug((Object)("Starting generic resource cache refresh cycle #" + this.cycleCount));
            } else {
                logger.debug((Object)"Forced to start generic resource cache refresh");
            }
            millisSinceLastRefresh = 0L;
            OpenSearchDataSourceResourceHome wsHome = (OpenSearchDataSourceResourceHome)StatefulContext.getPortTypeContext().getWSHome();
            Collection resourceKeys = wsHome.getIdentifiers();
            for (GCUBEWSResourceKey resourceKey : resourceKeys) {
                GCUBEWSResource resource;
                block42: {
                    try {
                        resource = wsHome.find((ResourceKey)resourceKey);
                        if (!(resource instanceof OpenSearchDataSourceResource)) {
                        }
                        break block42;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to retrieve WS resource " + resourceKey + ". Skipping."));
                    }
                    continue;
                }
                ISOpenSearchResourceCache cache = ((OpenSearchDataSourceResource)resource).cache;
                String[] ddURIs = ((OpenSearchDataSourceResource)resource).getDescriptionDocumentURI();
                Object[] genericResourceIds = ((OpenSearchDataSourceResource)resource).getOpenSearchResource();
                GCUBEScope scope = GCUBEScope.getScope((String)((String)((OpenSearchDataSourceResource)resource).getResourcePropertySet().getScope().get(0)));
                EnvHintCollection envHints = ((OpenSearchDataSourceResource)resource).getISEnvHints();
                int providerCount = ((OpenSearchDataSourceResource)resource).getCollectionID().length;
                String[] genericResourceXML = new String[providerCount];
                boolean genericResourceFail = false;
                for (int i = 0; i < providerCount; ++i) {
                    try {
                        genericResourceXML[i] = OpenSearchDataSourceResource.retrieveGenericResource(genericResourceIds[i], scope).toString();
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to retrieve generic resource with id " + genericResourceIds[i] + ". Skipping cache refreshing for this resource"), (Throwable)e);
                        genericResourceFail = true;
                        break;
                    }
                }
                if (genericResourceFail) continue;
                ISOpenSearchResourceCache iSOpenSearchResourceCache = cache;
                synchronized (iSOpenSearchResourceCache) {
                    int i;
                    ISOpenSearchResource[] savedResources = new ISOpenSearchResource[providerCount];
                    String[] savedDdUris = new String[providerCount];
                    for (i = 0; i < providerCount; ++i) {
                        savedResources[i] = ((OpenSearchDataSourceResource)resource).openSearchGenericResources[i];
                        savedDdUris[i] = ((OpenSearchDataSourceResource)resource).getDescriptionDocumentURI(i);
                    }
                    cache.descriptionDocuments.clear();
                    cache.resources.clear();
                    cache.resourcesXML.clear();
                    cache.XSLTs.clear();
                    for (i = 0; i < providerCount; ++i) {
                        boolean fail = false;
                        try {
                            ((OpenSearchDataSourceResource)resource).openSearchGenericResources[i] = new ISOpenSearchResource(genericResourceXML[i], cache.descriptionDocuments, cache.resourcesXML, cache.XSLTs, envHints);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Could not create OpenSearch resource instance during cache refreshing. Using old instance.", (Throwable)e);
                            fail = true;
                        }
                        cache.resources.put(ddURIs[i], ((OpenSearchDataSourceResource)resource).openSearchGenericResources[i]);
                        if (!fail) {
                            DescriptionDocument dd = null;
                            ddURIs[i] = ((OpenSearchDataSourceResource)resource).openSearchGenericResources[i].getDescriptionDocURL();
                            try {
                                dd = new DescriptionDocument(((OpenSearchDataSourceResource)resource).openSearchGenericResources[i].getDescriptionDocument(), (URLElementFactory)new BasicURLElementFactory(), (QueryElementFactory)new BasicQueryElementFactory());
                            }
                            catch (Exception e) {
                                logger.warn((Object)"Could not create Description Document instance during cache refreshing. Using old OpenSearch resource instance.", (Throwable)e);
                                fail = true;
                            }
                            if (!fail && !fail) {
                                try {
                                    if (i == 0) {
                                        ((OpenSearchDataSourceResource)resource).setDescriptionDocumentURI(ddURIs[i]);
                                    } else {
                                        ((OpenSearchDataSourceResource)resource).addDescriptionDocumentURI(ddURIs[i]);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn((Object)"Could not update WS resource with the new Description Document URI. Using old OpenSearch resource instance", (Throwable)e);
                                    fail = true;
                                }
                            }
                            if (fail) {
                                Exception ex = null;
                                try {
                                    cache.resources.clear();
                                    for (int j = 0; j < providerCount; ++j) {
                                        ((OpenSearchDataSourceResource)resource).openSearchGenericResources[j] = savedResources[j];
                                        ((OpenSearchDataSourceResource)resource).setDescriptionDocumentURI(savedDdUris);
                                        cache.resources.put(savedDdUris[j], savedResources[j]);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Failed to revert to old state after failure of cache refresh for WS resource bound to generic resources with ids " + Arrays.toString(genericResourceIds)));
                                    ex = e;
                                }
                                if (ex != null) continue;
                                logger.warn((Object)("Failed to refresh cache for WS resource bound to generic resources with ids " + Arrays.toString(genericResourceIds)));
                                continue;
                            }
                            ++refreshCount;
                            continue;
                        }
                        ++failed;
                    }
                    logger.debug((Object)("Refreshed cache and updated state of WS resource bound to generic resources with ids " + Arrays.toString(genericResourceIds)));
                }
            }
            if (!explicitRefreshRequested) {
                logger.debug((Object)("Ended generic resource cache refresh cycle #" + this.cycleCount));
                ++this.cycleCount;
            } else {
                logger.debug((Object)"Ended forced generic resource cache refreshing");
            }
            logger.debug((Object)("Total generic resource caches refreshed: " + refreshCount));
            logger.debug((Object)("Total generic resource cache refresh operations failed: " + failed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRefresh() {
        Object object = this.synchMe;
        synchronized (object) {
            this.forceRefresh = true;
            this.synchMe.notify();
        }
    }
}

