/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.processor;

import org.gcube.opensearch.opensearchdatasource.processor.GCQLNodeAnnotation;
import org.gcube.opensearch.opensearchdatasource.processor.GcqlProcessor;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLProxNode;
import search.library.util.cql.query.tree.GCQLTermNode;

public class OpenSearchGcqlAnnotator {
    public GCQLNodeAnnotation processNode(GCQLNode node) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node);
        }
        if (node instanceof GCQLProxNode) {
            return this.processNode((GCQLProxNode)node);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    public String getFirstEncounteredCollectionId(GCQLNodeAnnotation node) {
        String rightCol;
        String leftCol;
        if (node.collectionId != null) {
            return node.collectionId;
        }
        if (node.left != null && (leftCol = this.getFirstEncounteredCollectionId(node.left)) != null) {
            return leftCol;
        }
        if (node.right != null && (rightCol = this.getFirstEncounteredCollectionId(node.right)) != null) {
            return rightCol;
        }
        return null;
    }

    private GCQLNodeAnnotation processNode(GCQLProjectNode node) throws Exception {
        GCQLNodeAnnotation subAnnotation = this.processNode(node.subtree);
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        an.left = subAnnotation;
        return an;
    }

    private GCQLNodeAnnotation processNode(GCQLAndNode node) throws Exception {
        GCQLNodeAnnotation leftAnnotation = this.processNode(node.left);
        GCQLNodeAnnotation rightAnnotation = this.processNode(node.right);
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        if (node.left instanceof GCQLTermNode && node.right instanceof GCQLTermNode) {
            if (leftAnnotation.collectionId != null) {
                rightAnnotation.collectionId = leftAnnotation.collectionId;
                an.collectionId = leftAnnotation.collectionId;
            } else if (rightAnnotation.collectionId != null) {
                leftAnnotation.collectionId = rightAnnotation.collectionId;
                an.collectionId = rightAnnotation.collectionId;
            }
        } else if (leftAnnotation.collectionId == null) {
            an.collectionId = rightAnnotation.collectionId;
            this.propagateCollectionId(leftAnnotation, rightAnnotation.collectionId);
        } else if (rightAnnotation.collectionId == null) {
            an.collectionId = leftAnnotation.collectionId;
            this.propagateCollectionId(rightAnnotation, leftAnnotation.collectionId);
        }
        an.left = leftAnnotation;
        an.right = rightAnnotation;
        return an;
    }

    private GCQLNodeAnnotation processNode(GCQLOrNode node) throws Exception {
        GCQLNodeAnnotation leftAnnotation = this.processNode(node.left);
        GCQLNodeAnnotation rightAnnotation = this.processNode(node.right);
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        if (node.left instanceof GCQLTermNode && node.right instanceof GCQLTermNode) {
            if (leftAnnotation.collectionId != null) {
                rightAnnotation.collectionId = leftAnnotation.collectionId;
                an.collectionId = leftAnnotation.collectionId;
            } else if (rightAnnotation.collectionId != null) {
                leftAnnotation.collectionId = rightAnnotation.collectionId;
                an.collectionId = rightAnnotation.collectionId;
            }
        } else if (leftAnnotation.collectionId == null) {
            this.propagateCollectionId(leftAnnotation, rightAnnotation.collectionId);
        } else if (rightAnnotation.collectionId == null) {
            this.propagateCollectionId(rightAnnotation, leftAnnotation.collectionId);
        }
        an.left = leftAnnotation;
        an.right = rightAnnotation;
        return an;
    }

    private GCQLNodeAnnotation processNode(GCQLTermNode node) throws Exception {
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        if (node.getIndex().equals("gDocCollectionID")) {
            an.collectionId = GcqlProcessor.removeQuotes(node.getTerm());
        }
        return an;
    }

    private GCQLNodeAnnotation processNode(GCQLProxNode node) throws Exception {
        GCQLNodeAnnotation leftAnnotation = this.processNode(node.left);
        GCQLNodeAnnotation rightAnnotation = this.processNode(node.right);
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        if (node.left instanceof GCQLTermNode && node.right instanceof GCQLTermNode) {
            if (leftAnnotation.collectionId != null) {
                rightAnnotation.collectionId = leftAnnotation.collectionId;
                an.collectionId = leftAnnotation.collectionId;
            } else if (rightAnnotation.collectionId != null) {
                leftAnnotation.collectionId = rightAnnotation.collectionId;
                an.collectionId = rightAnnotation.collectionId;
            }
        } else if (leftAnnotation.collectionId == null) {
            this.propagateCollectionId(leftAnnotation, rightAnnotation.collectionId);
        } else if (rightAnnotation.collectionId == null) {
            this.propagateCollectionId(rightAnnotation, leftAnnotation.collectionId);
        }
        an.left = leftAnnotation;
        an.right = rightAnnotation;
        return an;
    }

    private GCQLNodeAnnotation processNode(GCQLNotNode node) throws Exception {
        GCQLNodeAnnotation leftAnnotation = this.processNode(node.left);
        GCQLNodeAnnotation rightAnnotation = this.processNode(node.right);
        GCQLNodeAnnotation an = new GCQLNodeAnnotation();
        if (node.left instanceof GCQLTermNode && node.right instanceof GCQLTermNode) {
            if (leftAnnotation.collectionId != null) {
                rightAnnotation.collectionId = leftAnnotation.collectionId;
                an.collectionId = leftAnnotation.collectionId;
            } else if (rightAnnotation.collectionId != null) {
                leftAnnotation.collectionId = rightAnnotation.collectionId;
                an.collectionId = rightAnnotation.collectionId;
            }
        } else if (leftAnnotation.collectionId == null) {
            this.propagateCollectionId(leftAnnotation, rightAnnotation.collectionId);
        } else if (rightAnnotation.collectionId == null) {
            this.propagateCollectionId(rightAnnotation, leftAnnotation.collectionId);
        }
        an.left = leftAnnotation;
        an.right = rightAnnotation;
        return an;
    }

    private void propagateCollectionId(GCQLNodeAnnotation annotation, String collectionId) {
        if (annotation.left != null) {
            this.propagateCollectionId(annotation.left, collectionId);
        }
        if (annotation.right != null) {
            this.propagateCollectionId(annotation.right, collectionId);
        }
        annotation.collectionId = collectionId;
    }
}

