/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.service.helpers;

import com.google.common.base.Splitter;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryClassNamePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchDataSourceConfig {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchDataSourceConfig.class);
    private Boolean clearCacheOnStartup;
    private Long cacheRefreshIntervalMillis;
    private Map<String, FactoryClassNamePair> factories = new HashMap();

    public Boolean getClearCacheOnStartup() {
        return this.clearCacheOnStartup;
    }

    public Long getCacheRefreshIntervalMillis() {
        return this.cacheRefreshIntervalMillis;
    }

    public Map<String, FactoryClassNamePair> getFactories() {
        return this.factories;
    }

    public void setClearCacheOnStartup(Boolean clearCacheOnStartup) {
        this.clearCacheOnStartup = clearCacheOnStartup;
    }

    public void setCacheRefreshIntervalMillis(Long cacheRefreshIntervalMillis) {
        this.cacheRefreshIntervalMillis = cacheRefreshIntervalMillis;
    }

    public void initFromPropertiesFile() throws Exception {
        Long cacheRefreshIntervalMillis;
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
        }
        catch (Exception e) {
            throw new Exception("could not load property file  : deploy.properties");
        }
        this.cacheRefreshIntervalMillis = cacheRefreshIntervalMillis = Long.valueOf(properties.getProperty("cacheRefreshIntervalMillis"));
        String factoriesString = properties.getProperty("factories");
        for (String mapEntryStr : Splitter.on((String)"###").trimResults().omitEmptyStrings().splitToList((CharSequence)factoriesString)) {
            List mapEntryList = Splitter.on((String)"=").trimResults().omitEmptyStrings().splitToList((CharSequence)mapEntryStr);
            String key = (String)mapEntryList.get(0);
            String value = (String)mapEntryList.get(1);
            this.factories.put(key, new FactoryClassNamePair(value));
        }
        logger.debug("Initialized OpenSearchDataSource Config:\n   clearCacheOnStartup: " + this.clearCacheOnStartup + "\n   cacheRefreshIntervalMillis: " + cacheRefreshIntervalMillis + "\n   factories: " + this.factories);
    }
}

