/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.service;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.utils.Locators;
import gr.uoa.di.madgik.rr.element.search.Field;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.opensearch.opensearchdatasource.processor.FieldDefinitionInfo;
import org.gcube.opensearch.opensearchdatasource.processor.GCQLNodeAnnotation;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchCollectionEnricher;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlAnnotator;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlCollectionQuery;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlProcessor;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlQueryContainer;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchProjector;
import org.gcube.opensearch.opensearchdatasource.service.helpers.OpenSearchDataSourceConfig;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.queryelements.BasicQueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.BasicURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchoperator.OpenSearchOp;
import org.gcube.opensearch.opensearchoperator.OpenSearchOpConfig;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLNode;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class OpenSearchOperator {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchOperator.class);
    private final InformationCollector icollector;
    private OpenSearchOpConfig openSearchOpConfig;

    @Inject
    public OpenSearchOperator(InformationCollector icollector) {
        this.icollector = icollector;
    }

    public static String[] retrieveTemplates(DescriptionDocument dd, OpenSearchResource res) throws Exception {
        Map uniqueTemplates = dd.getUniqueTemplates();
        ArrayList supportedTemplates = new ArrayList();
        for (List templates : uniqueTemplates.values()) {
            supportedTemplates.addAll(templates);
        }
        return supportedTemplates.toArray(new String[1]);
    }

    protected static void filterFieldInfo(List<String> fields, List<String> presentableFields, List<String> searchableFields) {
        presentableFields.clear();
        searchableFields.clear();
        HashSet<String> searchableSet = new HashSet<String>();
        HashSet<String> presentableSet = new HashSet<String>();
        for (String field : fields) {
            String fieldName = OpenSearchOperator.getFieldName((String)field, (String)"p");
            if (fieldName != null) {
                if (!presentableSet.add(fieldName)) continue;
                logger.trace("added presentable field: " + fieldName);
                presentableFields.add(fieldName);
                continue;
            }
            fieldName = OpenSearchOperator.getFieldName((String)field, (String)"s");
            if (!searchableSet.add(fieldName)) continue;
            logger.trace("added searchable field: " + fieldName);
            searchableFields.add(fieldName);
        }
    }

    private static String getFieldName(String field, String type) {
        int from = field.indexOf(":", field.indexOf(":") + 1) + 1;
        String t = field.substring(from, from + type.length());
        if (!t.equals(type)) {
            return null;
        }
        from = field.indexOf(":", from) + 1;
        int to = field.indexOf(":", from);
        return field.substring(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviders(OpenSearchDataSourceResource resource, List<String> fields, List<String> collectionIds, List<String> openSearchResourceIDs, List<OpenSearchDataSourceResource.FixedParam> fixedParams) throws Exception {
        logger.info("addProviders is called!");
        logger.info("fields                : " + fields);
        logger.info("collectionIds         : " + collectionIds);
        logger.info("openSearchResourceIDs : " + openSearchResourceIDs);
        logger.info("fixedParams           : " + fixedParams);
        int providerToAddCount = collectionIds.size();
        List savedFixedParams = resource.getFixedParameters();
        ArrayList savedOpenSearchResources = Lists.newArrayList((Object[])resource.openSearchGenericResources);
        ArrayList openSearchResourcesToAdd = Lists.newArrayList();
        ArrayList openSearchResourceXML = Lists.newArrayList();
        for (int i = 0; i < providerToAddCount; ++i) {
            String resXML = this.retrieveGenericResource(openSearchResourceIDs.get(i), resource.getScope());
            if (resource.getOpenSearchResourceXML().contains(resXML)) {
                logger.info("resource : " + openSearchResourceIDs.get(i) + " already added");
                continue;
            }
            openSearchResourceXML.add(resXML);
            ISOpenSearchResourceCache iSOpenSearchResourceCache = resource.cache;
            synchronized (iSOpenSearchResourceCache) {
                logger.info("Initializing with  : \n" + (String)openSearchResourceXML.get(i));
                openSearchResourcesToAdd.add(new ISOpenSearchResource((String)openSearchResourceXML.get(i), resource.cache.descriptionDocuments, resource.cache.resourcesXML, resource.cache.XSLTs, resource.getEnvHints()));
                continue;
            }
        }
        logger.info("providerToAddCount was         : " + providerToAddCount);
        providerToAddCount = openSearchResourceXML.size();
        logger.info("providerToAddCount changed to  : " + providerToAddCount);
        resource.setFields((List)Lists.newArrayList(fields));
        logger.info("Just added to the resource property set fields : " + resource.getFields());
        resource.allPresentableNames.clear();
        for (String field : resource.getFields()) {
            List f;
            Object[] splitField = field.split(":");
            logger.info("splitField : " + Arrays.toString(splitField));
            if (!((String)splitField[splitField.length - 2]).equals("p") || (f = Field.getFieldsWithName((boolean)false, (String)splitField[splitField.length - 1])).isEmpty()) continue;
            resource.allPresentableNames.add(((Field)f.get(0)).getName());
        }
        OpenSearchOperator.filterFieldInfo((List)resource.getFields(), (List)resource.presentableFields, (List)resource.searchableFields);
        try {
            int providerCount = resource.getCollections().size();
            resource.setFixedParameters(new ArrayList());
            resource.openSearchGenericResources = new ISOpenSearchResource[providerCount + providerToAddCount];
            int i = 0;
            for (i = 0; i < providerCount; ++i) {
                resource.getFixedParameters().add(savedFixedParams.get(i));
                resource.openSearchGenericResources[i] = (ISOpenSearchResource)savedOpenSearchResources.get(i);
            }
            logger.info("openSearchResourcesToAdd : " + openSearchResourcesToAdd);
            for (int j = 0; j < providerToAddCount; ++j) {
                OpenSearchDataSourceResource.FixedParam fixedParam = fixedParams.get(j);
                resource.getFixedParameters().add(fixedParam);
                resource.openSearchGenericResources[i + j] = (ISOpenSearchResource)openSearchResourcesToAdd.get(j);
                resource.getCollections().add(collectionIds.get(j));
                logger.debug("Just added to the resource property set collections : " + resource.getCollections());
                resource.getOpenSearchResource().add(openSearchResourceIDs.get(j));
                logger.debug("Just added to the resource property set openSearchResources : " + resource.getOpenSearchResource());
                String descriptionDoc = resource.openSearchGenericResources[i + j].getDescriptionDocURL();
                logger.info("description doc to be added : " + descriptionDoc);
                resource.getDescriptionDocumentURI().add(resource.openSearchGenericResources[i + j].getDescriptionDocURL());
                logger.debug("Just added to the resource property set RP_DESCRIPTION_DOCUMENT_URI : " + resource.getDescriptionDocumentURI());
            }
        }
        catch (Exception e) {
            resource.setFixedParameters(savedFixedParams);
            resource.openSearchGenericResources = (ISOpenSearchResource[])Iterables.toArray((Iterable)savedOpenSearchResources, ISOpenSearchResource.class);
            throw e;
        }
    }

    public String retrieveGenericResource(String resourceID, String scope) throws Exception {
        List resources = this.icollector.getGenericResourcesByID(resourceID, scope);
        String resourceBody = ((Resource)resources.get(0)).getBodyAsString();
        return resourceBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(OpenSearchDataSourceResource resource, String scope) throws Exception {
        int providerCount = resource.getCollections().size();
        String[] genericResourceXML = new String[providerCount];
        for (int i = 0; i < providerCount; ++i) {
            genericResourceXML[i] = this.retrieveGenericResource((String)resource.getOpenSearchResource().get(i), scope).toString();
        }
        ISOpenSearchResourceCache iSOpenSearchResourceCache = resource.cache;
        synchronized (iSOpenSearchResourceCache) {
            int i;
            ISOpenSearchResource[] savedResources = new ISOpenSearchResource[providerCount];
            ArrayList savedDdUris = Lists.newArrayList();
            for (i = 0; i < providerCount; ++i) {
                savedResources[i] = resource.openSearchGenericResources[i];
                savedDdUris.add(resource.getDescriptionDocumentURI().get(i));
            }
            resource.cache.descriptionDocuments.clear();
            resource.cache.resources.clear();
            resource.cache.resourcesXML.clear();
            resource.cache.XSLTs.clear();
            for (i = 0; i < providerCount; ++i) {
                String genericResourceId = (String)resource.getOpenSearchResource().get(i);
                ISOpenSearchResourceCache cache = resource.cache;
                String ddURI = (String)savedDdUris.get(i);
                EnvHintCollection envHints = resource.getISEnvHints();
                Exception ex = null;
                boolean fail = false;
                try {
                    resource.openSearchGenericResources[i] = new ISOpenSearchResource(genericResourceXML[i], cache.descriptionDocuments, cache.resourcesXML, cache.XSLTs, envHints);
                }
                catch (Exception e) {
                    logger.warn("Could not create OpenSearch resource instance during cache clearing. Using old instance.", (Throwable)e);
                    fail = true;
                    ex = e;
                }
                cache.resources.put(ddURI, resource.openSearchGenericResources[i]);
                if (fail) continue;
                DescriptionDocument dd = null;
                ddURI = resource.openSearchGenericResources[i].getDescriptionDocURL();
                try {
                    dd = new DescriptionDocument(resource.openSearchGenericResources[i].getDescriptionDocument(), (URLElementFactory)new BasicURLElementFactory(), (QueryElementFactory)new BasicQueryElementFactory());
                }
                catch (Exception e) {
                    logger.warn("Could not create Description Document instance during cache clearing. Using old OpenSearch resource instance.", (Throwable)e);
                    fail = true;
                    ex = e;
                }
                if (!fail && !fail) {
                    try {
                        if (i == 0) {
                            resource.setDescriptionDocumentURI(ddURI);
                        } else {
                            resource.getDescriptionDocumentURI().add(ddURI);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Could not update WS resource with the new Description Document URI. Using old OpenSearch resource instance", (Throwable)e);
                        fail = true;
                        ex = e;
                    }
                }
                if (!fail) continue;
                cache.resources.clear();
                for (int j = 0; j < providerCount; ++j) {
                    resource.openSearchGenericResources[j] = savedResources[j];
                    cache.resources.put(savedDdUris.get(j), savedResources[j]);
                }
                resource.setDescriptionDocumentURI((List)savedDdUris);
                throw ex;
            }
        }
    }

    public URI query(OpenSearchDataSourceResource resource, String cqlQuery) throws RemoteException {
        return this.query(resource, cqlQuery, true);
    }

    public OpenSearchOpConfig getOpenSearchOpConfig() {
        if (this.openSearchOpConfig == null) {
            OpenSearchDataSourceConfig config = new OpenSearchDataSourceConfig();
            Map factories = null;
            try {
                config.initFromPropertiesFile();
            }
            catch (Exception e) {
                logger.warn("error while reading from properties file", (Throwable)e);
                config = null;
            }
            if (config != null) {
                factories = config.getFactories();
                logger.debug("Read configuration property: factories = " + config.getFactories());
            } else {
                logger.warn("Could not read configuration property: factories. Operating using only basic factories");
            }
            this.openSearchOpConfig = new OpenSearchOpConfig(null, null, null, factories);
        }
        return this.openSearchOpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI query(OpenSearchDataSourceResource resource, String cqlQuery, boolean useRR) throws RemoteException {
        try {
            OpenSearchOpConfig cfg = this.getOpenSearchOpConfig();
            ISOpenSearchResourceCache iSOpenSearchResourceCache = resource.cache;
            synchronized (iSOpenSearchResourceCache) {
                cfg.ISCache = resource.cache;
            }
            OpenSearchGcqlProcessor processor = new OpenSearchGcqlProcessor();
            OpenSearchGcqlAnnotator annotator = new OpenSearchGcqlAnnotator();
            GCQLNode queryTree = processor.parseQuery(cqlQuery);
            GCQLNodeAnnotation annotationTree = annotator.processNode(queryTree);
            String collection = annotator.getFirstEncounteredCollectionId(annotationTree);
            processor.setAnnotationTree(annotationTree);
            processor.setCollection(collection);
            if (useRR) {
                processor.setFields(resource.allPresentableNames);
            } else {
                processor.setFields(resource.presentableFields);
            }
            processor.setDataSourceLocator(resource.getResourceID());
            logger.debug("Datasource locator is " + resource.getResourceID());
            processor.setUseRR(useRR);
            logger.info("processor searchables         : " + resource.searchableFields);
            logger.info("processor presentables        : " + resource.presentableFields);
            logger.info("processor allPresentableNames : " + resource.allPresentableNames);
            logger.info("collections : " + resource.getCollections());
            OpenSearchGcqlQueryContainer query = (OpenSearchGcqlQueryContainer)processor.processQuery(resource.presentableFields, resource.searchableFields);
            int index = -1;
            for (int i = 0; i < resource.getCollections().size(); ++i) {
                if (!((String)resource.getCollections().get(i)).equals(processor.getCollection())) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw new RemoteException("Could not locate provider");
            }
            logger.info("fixedParms : " + resource.getFixedParameters());
            if (resource.getFixedParameters() == null) {
                resource.setFixedParameters(new ArrayList());
            }
            logger.info("this.openSearchGenericResources[index] : " + resource.openSearchGenericResources[index]);
            logger.info("this.fixedParameters.get(index)        : " + resource.getFixedParameters().get(index));
            logger.info("cfg                                    : " + cfg);
            Object[] params = (String[])Iterables.toArray((Iterable)((OpenSearchDataSourceResource.FixedParam)resource.getFixedParameters().get(index)).getParams(), String.class);
            logger.info("params                                 : " + Arrays.toString(params));
            OpenSearchOp op = new OpenSearchOp((OpenSearchResource)resource.openSearchGenericResources[index], (String[])params, cfg, new EnvHintCollection());
            URI loc = op.query(((OpenSearchGcqlCollectionQuery)((ArrayList)((HashMap)query.queries.get(processor.getCollection())).get("*")).get(0)).toString());
            OpenSearchCollectionEnricher colEnricher = new OpenSearchCollectionEnricher(collection, loc);
            new Thread((Runnable)colEnricher).start();
            loc = colEnricher.getLocator();
            FieldDefinitionInfo fieldDefInfo = this.createFieldDefinition(query.getProjectedFields());
            FieldDefinition[] fieldDef = fieldDefInfo.fieldDefinition;
            Map fieldPositions = fieldDefInfo.fieldPositions;
            RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
            OpenSearchProjector projector = new OpenSearchProjector(loc, definition, processor.getProjectedFields(), fieldPositions);
            projector.setReaderTimeout(3L, TimeUnit.MINUTES);
            new Thread((Runnable)projector).start();
            return Locators.localToTCP((URI)projector.getProjectionLocator());
        }
        catch (Exception e) {
            logger.error("Unable to execute query: \"" + cqlQuery + "\"", (Throwable)e);
            throw new RemoteException("Could not execute query", e);
        }
    }

    private FieldDefinitionInfo createFieldDefinition(Map<String, String> projections) {
        Integer pos = 0;
        HashMap<String, Integer> fieldPositions = new HashMap<String, Integer>();
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        fieldDef.add(new StringFieldDefinition("gDocCollectionID"));
        Iterator<Map.Entry<String, String>> iterator = pos;
        Integer n = pos = Integer.valueOf(pos + 1);
        fieldPositions.put("gDocCollectionID", (Integer)((Object)iterator));
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        iterator = pos;
        n = pos = Integer.valueOf(pos + 1);
        fieldPositions.put("ObjectID", (Integer)((Object)iterator));
        if (projections.size() > 0) {
            Integer n2;
            Integer n3;
            String fieldId;
            String proj;
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = (String)current.getValue();
                fieldId = (String)current.getKey();
                if (!proj.equalsIgnoreCase("gDocCollectionID")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                n3 = pos;
                n2 = pos = Integer.valueOf(pos + 1);
                fieldPositions.put("gDocCollectionID", n3);
            }
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = current.getValue();
                fieldId = current.getKey();
                if (!proj.equalsIgnoreCase("gDocCollectionLang")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                n3 = pos;
                n2 = pos = Integer.valueOf(pos + 1);
                fieldPositions.put("gDocCollectionLang", n3);
            }
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = current.getValue();
                fieldId = current.getKey();
                if (proj.equalsIgnoreCase("gDocCollectionLang") || proj.equalsIgnoreCase("gDocCollectionID")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                fieldPositions.put(fieldId, pos);
                n3 = pos;
                n2 = pos = Integer.valueOf(pos + 1);
            }
            if (fieldDef.size() == 1) {
                logger.error(" no valid projection ");
            }
        }
        return new FieldDefinitionInfo(fieldDef.toArray(new FieldDefinition[fieldDef.size()]), fieldPositions);
    }
}

