/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.responseelements;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.responseelements.OpenSearchResponse;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLResponse
extends OpenSearchResponse {
    public XMLResponse(InputStream in, QueryElementFactory qElFactory, QueryBuilder qb, String encoding, Map<String, String> nsPrefixes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        BufferedReader bIn = new BufferedReader(new InputStreamReader(in));
        InputSource is = new InputSource(bIn);
        if (encoding.compareTo("UTF-8") != 0) {
            is.setEncoding(encoding);
        }
        this.response = builder.parse(is);
        this.nsPrefixes = nsPrefixes;
        Node n = this.response.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "totalResults").item(0);
        boolean hasTotalResults = true;
        if (n != null) {
            this.totalResults = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
        } else {
            this.isLastPage = true;
            hasTotalResults = false;
        }
        n = this.response.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "startIndex").item(0);
        if (n != null) {
            this.startIndex = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
        } else {
            if (!hasTotalResults) {
                this.containsInfo = false;
            }
            this.isFirstPage = true;
        }
        n = this.response.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "itemsPerPage").item(0);
        if (n != null) {
            this.itemsPerPage = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
        }
        int count = 0;
        while ((n = this.response.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "Query").item(count++)) != null) {
            try {
                this.createQueryBuilder(n, qElFactory, qb);
            }
            catch (Exception e) {
                this.logger.warn("Ignored a Query element contained in a response element. Cause:", (Throwable)e);
            }
        }
        if (!this.containsInfo) {
            this.isLastPage = null;
            this.isFirstPage = null;
        }
    }
}

