/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.query.IncompleteQueryException;
import org.gcube.opensearch.opensearchlibrary.query.NonExistentParameterException;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.queryelements.BasicQueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.BasicURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.ExtendedURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryResolver;
import org.gcube.opensearch.opensearchoperator.OpenSearchOpConfig;
import org.gcube.opensearch.opensearchoperator.OpenSearchWorker;
import org.gcube.opensearch.opensearchoperator.QueryParser;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.opensearch.opensearchoperator.resource.ISResourceRepository;
import org.gcube.opensearch.opensearchoperator.resource.LocalOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.LocalResourceRepository;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchOp {
    private Logger logger = LoggerFactory.getLogger((String)OpenSearchOp.class.getName());
    private OpenSearchResource resource;
    private ResourceRepository resources;
    private OpenSearchOpConfig config;
    private String[] fixedParams;
    private EnvHintCollection envHints = null;

    public OpenSearchOp(OpenSearchResource resource, String[] fixedParams, EnvHintCollection envHints) throws Exception {
        this.resource = resource;
        this.config = new OpenSearchOpConfig();
        this.envHints = envHints;
        this.fixedParams = fixedParams;
        if (!this.config.useLocalResourceRepository.booleanValue()) {
            ISOpenSearchResourceCache cache = this.config.ISCache == null ? new ISOpenSearchResourceCache() : this.config.ISCache;
            this.resources = new ISResourceRepository(cache, envHints);
        } else {
            this.resources = new LocalResourceRepository(new File(this.config.schemaPath));
            ((LocalResourceRepository)this.resources).add(this.config.dirPath);
        }
    }

    public OpenSearchOp(OpenSearchResource resource, String[] fixedParams, OpenSearchOpConfig config, EnvHintCollection envHints) throws Exception {
        this.resource = resource;
        this.config = config;
        this.envHints = envHints;
        this.fixedParams = fixedParams;
        if (!this.config.useLocalResourceRepository.booleanValue()) {
            ISOpenSearchResourceCache cache = config.ISCache == null ? new ISOpenSearchResourceCache() : config.ISCache;
            this.resources = new ISResourceRepository(cache, envHints);
        } else {
            this.resources = new LocalResourceRepository(new File(config.schemaPath));
            ((LocalResourceRepository)this.resources).add(config.dirPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI query(String queryString) throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            this.logger.info("OpenSearch operator received query: " + queryString);
            Object synchLocator = new Object();
            QueryParser parser = new QueryParser(queryString, this.fixedParams);
            FactoryResolver.initialize(parser.getNamespaces(), this.config.factories);
            OpenSearchWorker osw = new OpenSearchWorker(this.resource, this.resources, this.config, parser.getTerms(), parser.getParams(), parser.getFixedTerms(), parser.getFixedParamsMap(), parser.getNamespaces(), synchLocator);
            Thread worker = new Thread(osw);
            worker.start();
            URI outLocator = null;
            Object object = synchLocator;
            synchronized (object) {
                while ((outLocator = osw.getLocator()) == null) {
                    synchLocator.wait();
                }
            }
            long initStop = Calendar.getInstance().getTimeInMillis();
            this.logger.info("Time to initialize: " + (initStop - start));
            return outLocator;
        }
        catch (Exception e) {
            this.logger.error("Could not start background process. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start background process.");
        }
    }

    public static void main(String[] args) throws Exception {
        LocalOpenSearchResource res = new LocalOpenSearchResource(new File(System.getenv("HOME") + "/workspace/OpenSearch_Library/Resources/Nature.xml"), null);
        EnvHintCollection hints = new EnvHintCollection();
        OpenSearchOp op = new OpenSearchOp(res, new String[0], new EnvHintCollection());
        op.test(res);
    }

    public void test(OpenSearchResource res) throws Exception {
        String line;
        ExtendedURLElementFactory urlFactory = new ExtendedURLElementFactory(new BasicURLElementFactory());
        BasicQueryElementFactory queryFactory = new BasicQueryElementFactory();
        DescriptionDocument parser = new DescriptionDocument(res.getDescriptionDocument(), urlFactory, queryFactory);
        System.out.println("Name = " + res.getName());
        System.out.println("Brokered = " + res.isBrokered());
        System.out.println("Secure = " + res.isSecure());
        System.out.println("text/html transformer: " + res.getTransformer("text/html"));
        System.out.println("Can request = " + parser.canRequest());
        System.out.println("Can send to end users: " + parser.canSendToEndUsers());
        System.out.println("Can send to other clients: " + parser.canSendToClients());
        System.out.println("ShortName: " + parser.getShortName());
        System.out.println("LongName: " + parser.getLongName());
        System.out.println("Contact: " + parser.getContact());
        System.out.println("Description: " + parser.getDescription());
        System.out.println("Developer: " + parser.getDeveloper());
        URI imageURI = parser.getImageURI();
        if (imageURI != null) {
            System.out.println("Image URI: " + parser.getImageURI().toString());
        }
        System.out.println("Syndication Right: " + (Object)((Object)parser.getSyndicationRight()));
        System.out.println("Attribution: " + parser.getAttribution());
        System.out.println("Tags: " + parser.getTags());
        System.out.println("Language restriction: " + parser.hasLangRestriction());
        System.out.println("Languages supported: " + parser.getSupportedLanguages());
        System.out.println("Input encodings supported: " + parser.getSupportedInputEncodings());
        System.out.println("Output encodings supported: " + parser.getSupportedOutputEncodings());
        System.out.println("Result MIME types supported: " + parser.getSupportedMimeTypes("results"));
        System.out.println("-----------------------------------");
        List<QueryBuilder> qb = parser.getQueryBuilders("results", "application/atom+xml");
        System.out.println("Query builders: " + qb);
        System.out.println(qb.get(0).getRequiredParameters());
        System.out.println(qb.get(0).getOptionalParameters());
        qb.get(0).setParameter("searchTerms", "earth");
        qb.get(0).setParameter("count", "100").setParameter("startIndex", "5");
        System.out.println(qb.get(0).getQuery());
        List<QueryBuilder> exq = parser.getExampleQueryBuilders("application/atom+xml");
        System.out.println(exq.size() + " Example queries: " + exq);
        for (int i = 0; i < exq.size(); ++i) {
            String line2;
            try {
                System.out.println("Example query: " + exq.get(i).getQuery());
                exq.get(i).setParameter("startPage", "2");
            }
            catch (IncompleteQueryException e) {
                System.out.println(">>>Caught incomplete query exception<<<");
                System.out.println("Unset parameters: " + exq.get(i).getUnsetParameters());
                exq.get(i).setParameter(exq.get(i).getUnsetParameters().get(0), "10");
                System.out.println("Example query: " + exq.get(i).getQuery());
            }
            catch (NonExistentParameterException npe) {
                System.err.println(npe);
                continue;
            }
            URL exampleResults = new URL(exq.get(i).getQuery());
            URLConnection exampleResultsCon = exampleResults.openConnection();
            BufferedReader exIn = new BufferedReader(new InputStreamReader(exampleResultsCon.getInputStream()));
            BufferedWriter exOut = new BufferedWriter(new FileWriter("Output/exampleQueryResults_" + i + ".xml"));
            while ((line2 = exIn.readLine()) != null) {
                exOut.write(line2);
            }
            exOut.close();
        }
        URL results = new URL(qb.get(0).getQuery());
        URLConnection resultsCon = results.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(resultsCon.getInputStream()));
        BufferedWriter out = new BufferedWriter(new FileWriter("Output/queryResults.xml"));
        while ((line = in.readLine()) != null) {
            out.write(line);
        }
        out.close();
        System.out.println("-----------------------------------");
        URL exResults = new URL(exq.get(0).getQuery());
        URLConnection exResultsCon = exResults.openConnection();
        Transformer tr = res.getTransformer("application/atom+xml");
        System.out.println(tr);
        tr.setOutputProperty("method", "text");
        tr.transform(new StreamSource(new InputStreamReader(exResultsCon.getInputStream())), new StreamResult(new FileOutputStream("Output/tranformed.txt")));
    }
}

