package org.gcube.opensearch.opensearchoperator.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * A resource cache that caches generic resources, description documents in XML form
 * and OpenSearchResource objects. Used to avoid using the network or querying the 
 * InformationSystem every time a previously retrieved resource is requested 
 * 
 * @author gerasimos.farantatos
 *
 */
public class ISOpenSearchResourceCache {
	/**
	 * Associates description document URLs with description document XML representations
	 */
	public Map<String, String> descriptionDocuments = Collections.synchronizedMap(new HashMap<String, String>());
	/**
	 * Associates description document URLs with OpenSearchResources
	 */
	public Map<String, OpenSearchResource> resources = Collections.synchronizedMap(new HashMap<String, OpenSearchResource>());
	/**
	 * Associates description document URLs with OpenSearchResource XML representations
	 */
	public Map<String, String> resourcesXML = Collections.synchronizedMap(new HashMap<String, String>());
	/**
	 * Associates XSLT generic resource names with their XML representations 
	 */
	public Map<String, String> XSLTs = Collections.synchronizedMap(new HashMap<String, String>());
}
