/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary;

import java.net.URI;
import javax.activation.MimeType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ImageElement {
    private int width;
    private int height;
    private String MIMEType = null;
    private URI uri = null;

    public ImageElement(Element image) throws Exception {
        Attr n = image.getAttributeNode("width");
        if (n == null) {
            throw new Exception("Image element lacks width attribute");
        }
        try {
            this.width = Integer.parseInt(n.getNodeValue());
        }
        catch (Exception e) {
            throw new Exception("Invalid value in width element", e);
        }
        n = image.getAttributeNode("height");
        if (n == null) {
            throw new Exception("Image element lacks height attribute");
        }
        try {
            this.height = Integer.parseInt(n.getNodeValue());
        }
        catch (Exception e) {
            throw new Exception("Invalid value in height element", e);
        }
        n = image.getAttributeNode("type");
        if (n == null) {
            throw new Exception("Image element lacks type attribute");
        }
        this.MIMEType = n.getNodeValue();
        try {
            new MimeType(this.MIMEType);
        }
        catch (Exception e) {
            throw new Exception("Malformed MIME type in image element", e);
        }
        String s = image.getFirstChild().getNodeValue();
        try {
            this.uri = new URI(s);
        }
        catch (Exception e) {
            throw new Exception("Value of image element is not a valid URI", e);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getMimeType() {
        return this.MIMEType;
    }

    public URI getURI() throws Exception {
        URI u = null;
        try {
            u = new URI(this.uri.toString());
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception caught while copying a URI", e);
        }
        return u;
    }
}

