/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchlibrary.query.IncompleteQueryException;
import org.gcube.opensearch.opensearchlibrary.query.MalformedQueryException;
import org.gcube.opensearch.opensearchlibrary.query.NonExistentParameterException;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.query.URLTemplate;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.utils.URLEncoder;

public class BasicQueryBuilder
implements QueryBuilder {
    protected URLTemplate template;
    protected Map<String, String> values = new HashMap<String, String>();
    Integer startIndexDef = null;
    Integer startPageDef = null;

    public BasicQueryBuilder(URLTemplate template, String startIndexDef, String startPageDef) throws Exception {
        this.template = template;
        this.startIndexDef = Integer.parseInt(startIndexDef);
        this.startPageDef = Integer.parseInt(startPageDef);
        List<String> params = template.getRequiredParameters();
        params.addAll(template.getOptionalParameters());
        try {
            for (String param : params) {
                if (param.compareTo(OpenSearchConstants.startIndexQName) == 0 && template.isParameterRequired(param)) {
                    this.values.put(param, startIndexDef);
                    continue;
                }
                if (param.compareTo(OpenSearchConstants.startPageQName) == 0 && template.isParameterRequired(param)) {
                    this.values.put(param, startPageDef);
                    continue;
                }
                if (param.compareTo(OpenSearchConstants.countQName) == 0 && !template.isParameterRequired(param)) {
                    this.values.put(param, "100");
                    continue;
                }
                if (param.compareTo(OpenSearchConstants.languageQName) == 0 && template.isParameterRequired(param)) {
                    this.values.put(param, "*");
                    continue;
                }
                if ((param.compareTo(OpenSearchConstants.inputEncodingQName) == 0 || param.compareTo(OpenSearchConstants.outputEncodingQName) == 0) && template.isParameterRequired(param)) {
                    this.values.put(param, "UTF-8");
                    continue;
                }
                if (!template.isParameterRequired(param)) {
                    this.values.put(param, "");
                    continue;
                }
                this.values.put(param, null);
            }
        }
        catch (NonExistentParameterException e) {
            throw new Exception("Unexpected exception", e);
        }
    }

    public BasicQueryBuilder(URLTemplate template, String countDef, String startIndexDef, String startPageDef) throws Exception {
        this(template, startIndexDef, startPageDef);
        if (template.hasParameter(OpenSearchConstants.countQName)) {
            this.values.put(OpenSearchConstants.countQName, countDef);
        }
    }

    @Override
    public QueryBuilder clone() {
        BasicQueryBuilder qb;
        try {
            qb = new BasicQueryBuilder(this.template, this.getStartIndexDef().toString(), this.getStartPageDef().toString());
        }
        catch (Exception e) {
            return null;
        }
        return qb;
    }

    @Override
    public List<String> getRequiredParameters() {
        return new ArrayList<String>(this.template.getRequiredParameters());
    }

    @Override
    public List<String> getOptionalParameters() {
        return new ArrayList<String>(this.template.getOptionalParameters());
    }

    @Override
    public String getParameterValue(String name) throws NonExistentParameterException {
        if (!this.template.hasParameter(name)) {
            throw new NonExistentParameterException("Parameter not found", name);
        }
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        return null;
    }

    @Override
    public List<String> getUnsetParameters() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> params = this.template.getRequiredParameters();
        params.addAll(this.template.getOptionalParameters());
        for (String param : params) {
            if (!this.values.containsKey(param) || this.values.get(param) != null) continue;
            l.add(param);
        }
        return l;
    }

    @Override
    public String getRawTemplate() {
        return this.template.getTemplate();
    }

    @Override
    public boolean hasParameter(String name) {
        return this.template.hasParameter(name);
    }

    @Override
    public BasicQueryBuilder setParameter(String name, String value) throws NonExistentParameterException, Exception {
        if (!this.values.containsKey(name)) {
            throw new NonExistentParameterException("Parameter not found", name);
        }
        String replacement = name.compareTo(OpenSearchConstants.searchTermsQName) == 0 ? URLEncoder.UrlEncode(value, "UTF-8") : value;
        this.values.put(name, replacement);
        return this;
    }

    @Override
    public BasicQueryBuilder setParameter(String name, Integer value) throws NonExistentParameterException {
        if (!this.values.containsKey(name)) {
            throw new NonExistentParameterException("Parameter not found", name);
        }
        this.values.put(name, value.toString());
        return this;
    }

    @Override
    public BasicQueryBuilder setParameters(List<String> names, List<Object> values) throws NonExistentParameterException, Exception {
        if (names.size() != values.size()) {
            throw new Exception("List size mismatch");
        }
        Iterator<String> nameIt = names.iterator();
        Iterator<Object> valueIt = values.iterator();
        while (nameIt.hasNext()) {
            Object obj = valueIt.next();
            if (obj instanceof String) {
                this.setParameter(nameIt.next(), (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                this.setParameter(nameIt.next(), (Integer)obj);
                continue;
            }
            throw new ClassCastException();
        }
        return this;
    }

    @Override
    public boolean isParameterSet(String name) {
        try {
            if (this.getParameterValue(name) != null && !this.getParameterValue(name).equals("")) {
                return true;
            }
        }
        catch (NonExistentParameterException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isQueryComplete() {
        return !this.values.containsValue(null);
    }

    private void validateQuery() throws MalformedQueryException {
        for (String param : Arrays.asList(OpenSearchConstants.startIndexQName, OpenSearchConstants.startPageQName, OpenSearchConstants.countQName)) {
            if (!this.values.containsKey(param) || this.values.get(param) == null || this.values.get(param).compareTo("") == 0) continue;
            Integer intVal = null;
            try {
                intVal = Integer.parseInt(this.values.get(param));
            }
            catch (Exception e) {
                throw new MalformedQueryException("Incorrect parameter type", param);
            }
            if (param.compareTo(OpenSearchConstants.countQName) != 0 || intVal >= 0) continue;
            throw new MalformedQueryException("Non-negative value expected", param);
        }
    }

    @Override
    public String getQuery() throws IncompleteQueryException, MalformedQueryException, Exception {
        this.validateQuery();
        if (!this.isQueryComplete()) {
            throw new IncompleteQueryException();
        }
        String query = this.template.getTemplate();
        for (Map.Entry<String, String> e : this.values.entrySet()) {
            if (this.template.isParameterRequired(e.getKey())) {
                query = query.replaceAll("\\{" + e.getKey() + "\\}", e.getValue());
                continue;
            }
            query = query.replaceAll("\\{" + e.getKey() + "\\?\\}", e.getValue());
        }
        return query;
    }

    @Override
    public QueryBuilder setParameters(QueryElement queryEl) throws NonExistentParameterException, Exception {
        Map<String, String> m = queryEl.getQueryParameters();
        for (Map.Entry<String, String> e : m.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public Integer getStartIndexDef() {
        return this.startIndexDef;
    }

    @Override
    public Integer getStartPageDef() {
        return this.startPageDef;
    }

    public static void main(String[] args) throws Exception {
    }
}

