/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.responseelements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OpenSearchResponse {
    protected Document response = null;
    protected Integer totalResults = null;
    protected Integer startIndex = null;
    protected Integer itemsPerPage = null;
    protected Boolean isLastPage = false;
    protected Boolean isFirstPage = false;
    protected Map<String, String> nsPrefixes;
    protected boolean containsInfo = true;
    protected List<QueryElement> queryElements = new ArrayList<QueryElement>();
    protected Logger logger = LoggerFactory.getLogger((String)OpenSearchResponse.class.getName());
    protected Map<String, List<QueryBuilder>> queryBuilders = new HashMap<String, List<QueryBuilder>>();

    protected void createQueryBuilder(Node n, QueryElementFactory qElFactory, QueryBuilder qb) throws Exception {
        QueryElement queryEl = qElFactory.newInstance((Element)n, this.nsPrefixes);
        queryEl.parse();
        QueryBuilder newQb = qb.clone();
        newQb.setParameters(queryEl);
        if (!this.queryBuilders.containsKey(queryEl.getRole())) {
            this.queryBuilders.put(queryEl.getRole(), new ArrayList());
        }
        this.queryBuilders.get(queryEl.getRole()).add(newQb);
    }

    public Document getResponse() {
        return this.response;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public boolean containsPagingElements() {
        return this.containsInfo;
    }

    public List<QueryBuilder> getQueryBuilders(String role) {
        List<QueryBuilder> qbs = this.queryBuilders.get(role);
        if (qbs != null) {
            return new ArrayList<QueryBuilder>((Collection)this.queryBuilders.get(role));
        }
        return new ArrayList<QueryBuilder>();
    }
}

