package org.gcube.personalization.userprofileaccess.client.library.proxies;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.Destroy;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.GetElementResponse;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElement;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElementValue;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessStub;
import org.gcube.common.clients.Call;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessCLDefaultProxy implements UserProfileAccessCLProxyI {

	private final ProxyDelegate<UserProfileAccessStub> delegate;

	public UserProfileAccessCLDefaultProxy(ProxyDelegate<UserProfileAccessStub> config) {
		this.delegate = config;
	}

	@Override
	public void destroy() throws UserProfileAccessException {
		Call<UserProfileAccessStub, Empty> call = new Call<UserProfileAccessStub, Empty>() {
			@Override
			public Empty call(UserProfileAccessStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}


	@Override
	public String getUserProfile() throws UserProfileAccessException {
		Call<UserProfileAccessStub, String> call = new Call<UserProfileAccessStub, String>() {
			@Override
			public String call(UserProfileAccessStub endpoint) throws Exception {
				return endpoint.getUserProfile(new Empty());
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
		
	}

	@Override
	public String getElementValue(final String elementName) throws UserProfileAccessException {
		Call<UserProfileAccessStub, String> call = new Call<UserProfileAccessStub, String>() {
			@Override
			public String call(UserProfileAccessStub endpoint) throws Exception {
				return endpoint.getElementValue(elementName);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}

	@Override
	public void setElementValue(final SetElementValue params) throws UserProfileAccessException {
		Call<UserProfileAccessStub, Empty> call = new Call<UserProfileAccessStub, Empty>() {
			@Override
			public Empty call(UserProfileAccessStub endpoint) throws Exception {
				endpoint.setElementValue(params);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}

	@Override
	public GetElementResponse getElement(final String elementName) throws UserProfileAccessException {
		Call<UserProfileAccessStub, GetElementResponse> call = new Call<UserProfileAccessStub, GetElementResponse>() {
			@Override
			public GetElementResponse call(UserProfileAccessStub endpoint) throws Exception {
				return endpoint.getElement(elementName);
			}
		};
		try {
			GetElementResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}

	@Override
	public void setElement(final SetElement params) throws UserProfileAccessException {
		Call<UserProfileAccessStub, Empty> call = new Call<UserProfileAccessStub, Empty>() {
			@Override
			public Empty call(UserProfileAccessStub endpoint) throws Exception {
				endpoint.setElement(params);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
		
	}

	@Override
	public void deleteElement(final String elementName) throws UserProfileAccessException {
		Call<UserProfileAccessStub, String> call = new Call<UserProfileAccessStub, String>() {
			@Override
			public String call(UserProfileAccessStub endpoint) throws Exception {
				endpoint.deleteElement(elementName);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}

	@Override
	public void updateUserProfile(final String profileContent) throws UserProfileAccessException {
		Call<UserProfileAccessStub, String> call = new Call<UserProfileAccessStub, String>() {
			@Override
			public String call(UserProfileAccessStub endpoint) throws Exception {
				endpoint.updateUserProfile(profileContent);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}
}
