package org.gcube.personalization.userprofileaccess.client.library.utils;

import static org.gcube.common.clients.stubs.jaxws.GCoreServiceBuilder.*;

import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessFactoryStub;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessStub;

import javax.xml.namespace.QName;

/**
 * Constants for the UserProfileAccess CL library
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessCLConstants {
	public static final int DEFAULT_TIMEOUT= (int) TimeUnit.SECONDS.toMillis(600000);

	public static final String NAMESPACE = "http://gcube-system.org/namespaces/personalization/userprofileaccess";
	public static final String NAME = "gcube/personalization/userprofileaccess/UserProfileAccess";
	public static final String FACTORYNAME = "gcube/personalization/userprofileaccess/UserProfileAccessFactory";
	public static final QName name = new QName("http://gcube-system.org/namespaces/personalization/userprofileaccess/service", "UserProfileAccessService");
	public static final QName factoryname = new QName("http://gcube-system.org/namespaces/personalization/userprofileaccessfactory/service", "UserProfileAccessFactoryService");
	public static final String porttypeNS = "http://gcube-system.org/namespaces/personalization/userprofileaccess";
	public static final String porttypeLN = "UserProfileAccessPortType";
	public static final String factoryporttypeNS = "http://gcube-system.org/namespaces/personalization/userprofileaccessfactory";
	public static final String factoryporttypeLN = "UserProfileAccessFactoryPortType";
	
	//gcube/personalization/userprofileaccess/UserProfileAccess
	
	public static final String gcubeClass = "Personalisation";
	public static final String gcubeName = "UserProfileAccess";
	
	
	public static final GCoreService<UserProfileAccessStub> persin = service().withName(name)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(UserProfileAccessStub.class); 

	public static final GCoreService<UserProfileAccessFactoryStub> persinf = service().withName(factoryname)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(UserProfileAccessFactoryStub.class);

}