package org.gcube.personalization.userprofileaccess.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.CreateResourceResponse;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessFactoryStub;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessFactoryCLDefaultProxy implements UserProfileAccessFactoryCLProxyI {

	private final ProxyDelegate<UserProfileAccessFactoryStub> delegate;

	public UserProfileAccessFactoryCLDefaultProxy(ProxyDelegate<UserProfileAccessFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final String username) throws UserProfileAccessException {
		Call<UserProfileAccessFactoryStub, CreateResourceResponse> call = new Call<UserProfileAccessFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(UserProfileAccessFactoryStub endpoint) throws Exception {
				return endpoint.createResource(username);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new UserProfileAccessException(e);
		}
	}
}
