package org.gcube.personalization.userprofileaccess.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessFactoryCLDefaultProxy;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessFactoryCLProxyI;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessFactoryStub;
import org.gcube.personalization.userprofileaccess.client.library.utils.UserProfileAccessCLConstants;

/**
 * UserProfileAccess factory plugin exposes information that allows CL Framework
 * components to act on behalf of UserProfileAccess facotry CL. 
 * 
 * @author Panagiota Koltsida, NKUA
 * 
 */
public class UserProfileAccessFactoryCLPlugin implements Plugin<UserProfileAccessFactoryStub, UserProfileAccessFactoryCLProxyI> {

	@Override
	public String name() {
		return UserProfileAccessCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return UserProfileAccessCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return UserProfileAccessCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return UserProfileAccessCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public UserProfileAccessFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(UserProfileAccessCLConstants.persinf).at(reference);
	}

	@Override
	public UserProfileAccessFactoryCLProxyI newProxy(ProxyDelegate<UserProfileAccessFactoryStub> delegate) {
		return new UserProfileAccessFactoryCLDefaultProxy(delegate);
	}

}
