package UserProfileAccessClient;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.personalization.userprofileaccess.stubs.SetElement;
import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessFactoryPortType;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessFactoryServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessServiceAddressingLocator;

/**
 * This is a client for testing the UserProfileAccess service
 * It shows how to find a WS-Resource for a user profile, how to retrive the whole profile
 * or how to retrieve specific elements of the profile.
 * It also shows how to enhance the user profile.
 * 
 * For more information about the usage of the UserProfileAccess service please visit the D4Science wiki site
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessServiceClient {
	
	/**
	 * @param args0 = GCUBEScope
	 * @param args1 = the URI of a RI of the UserProfileAccessFactory service for the passed scope 
	 * @param args2 = Username of the user
	 */
	public static void main(String[] args) {
		
		UserProfileAccessFactoryServiceAddressingLocator uLocator = new UserProfileAccessFactoryServiceAddressingLocator();
		EndpointReferenceType userProfileAccessFactoryEpr = new EndpointReferenceType();
		EndpointReferenceType wsResourceEpr = new EndpointReferenceType();
		UserProfileAccessServiceAddressingLocator serviceLocator = new UserProfileAccessServiceAddressingLocator();
		UserProfileAccessFactoryPortType upa = null;
		UserProfileAccessPortType port = null;
		
		// pass the uri address of the service
		String factoryuri = args[1];
		
		/********************************************************************************
		 * 									PRINTING MESSAGES
		 ********************************************************************************/
		System.out.println("START TESTING........");
		System.out.println("The program's parameters are: ");
		for (int i=0; i<args.length; i++)
			System.out.println(i+1 + ": " + args[i]);
		
		try {
			userProfileAccessFactoryEpr.setAddress(new AttributedURI(factoryuri));
			System.out.println("Using UserProfileAcess service RI in: '" + factoryuri + "'");
		} catch (MalformedURIException e) {
			e.printStackTrace();
		}
		
		try {
			upa = uLocator.getUserProfileAccessFactoryPortTypePort(userProfileAccessFactoryEpr);
		} catch (ServiceException e) {
			e.printStackTrace();
		}

		try {
			upa = GCUBERemotePortTypeContext.getProxy(upa, GCUBEScope.getScope(args[0]));
			/*
			 * The 'createResource' method is the method that should be invoked to create a new ws-resource and a profile for a user.
			 * If the ws-resource already exists for this user it will return the existing one, otherwise it will create a new resource
			 */
			wsResourceEpr = upa.createResource(args[2]);
			System.out.println("A new WS resource was created with username: " + args[2]);
			System.out.println("The EPR of the created resource is: " + wsResourceEpr.toString());		
		} catch (Exception e) {
			System.out.println("An exception was thrown..... with message:" + e.getMessage());
			e.printStackTrace();
		}
		
		try {
			/* Pass the ws-resource EPR to get the port type. After getting the port type all the public methods of the service
				can be invoked
			*/
			port = serviceLocator.getUserProfileAccessPortTypePort(wsResourceEpr);
			port = GCUBERemotePortTypeContext.getProxy(port, GCUBEScope.getScope(args[0]));
			
			// The method 'getUserProfile' returns the user profile in a String representation
			// Invoke this method and print the profile
			String userProfile = port.getUserProfile(new VOID());
			System.out.println("The user's profile with username: " + args[2] + " is: <<" + userProfile + ">>");
			
			System.out.println("Start printing some elements of the user profile....... The default ones");
			
			/*
			 * Invoke the 'getElementValue' of the service in order to print the value of an existing element of the user's profile
			 */
			String fullname = port.getElementValue("/userprofile/userinfo/fullname");
			String email = port.getElementValue("/userprofile/userinfo/email");
			System.out.println("The fullname is: " + fullname);
			System.out.println("The email is: " + email);
			System.out.println("These elements have no values inside. Adding some values to these elements and print again...");
			
			// Add the parameters and pass them to the 'setElementValue' method
			SetElementValue params = new SetElementValue();
			params.setElementName("/userprofile/userinfo/fullname");
			params.setValue("A random fullname");
			port.setElementValue(params);
			
			params.setElementName("/userprofile/userinfo/email");
			params.setValue("myemail@email.com");
			port.setElementValue(params);
			
			System.out.println("Printing again the fullname and the email from the profile....");
			fullname = port.getElementValue("/userprofile/userinfo/fullname");
			email = port.getElementValue("/userprofile/userinfo/email");
			System.out.println("The fullname is: " + fullname);
			System.out.println("The email is: " + email);
			
			/* 
			 * Set a new element to the user's profile.
			 * Invoke the 'setElement' method
			 */
			SetElement setElemParams = new SetElement();
			setElemParams.setPath("/userprofile/preferences/searchpreferences");
			setElemParams.setElementName("favoriteCollection");
			setElemParams.setValue("ESA earth images");
			port.setElement(setElemParams);
			
			System.out.println("A new element with name: 'favoriteCollection' has been created.");
			System.out.println("Now the user's profile is: " + port.getUserProfile(new VOID()));
			
			System.out.println("Finally lets delete an element from the user's profile.");
			System.out.println("The 'fullname' element will be deleted");
			/*
			 * Invoke the 'deleteElement' method to delete an existing element from the user's profile
			 */
			port.deleteElement("/userprofile/userinfo/fullname");
			System.out.println("Now the user's profile is: " + port.getUserProfile(new VOID()));
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("An exception was thrown from the UserProfileAccessService...... with message: " + e.getMessage());
		}

		System.out.println("TESTING FINISHED....................");
	}

}

