/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin;

import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.TestResult;
import org.gcube.tools.searchtester.plugin.util.Util;

public class ASLHTTPRequest {
    GCUBELog logger = new GCUBELog(ASLHTTPRequest.class);
    HttpURLConnection httpURLConnection = null;
    String type;
    ParamMap parameters;

    public ASLHTTPRequest(String type) {
        this.type = type;
        this.parameters = new ParamMap();
    }

    public ASLHTTPRequest(String type, ParamMap parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    public TestResult makeRequest() {
        HttpClient client = new HttpClient();
        StatusLine statusLine = null;
        int statusCode = 0;
        String responseBody = null;
        Double executionTime = 0.0;
        GetMethod method = null;
        try {
            URL url = Util.createURL(PluginContext.HTPPAPIURL, this.type);
            url = this.parameters.setParameter(url);
            this.logger.debug((Object)("setting request url: " + url));
            method = new GetMethod(url.toString());
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            long start = System.currentTimeMillis();
            statusCode = client.executeMethod((HttpMethod)method);
            long end = System.currentTimeMillis();
            executionTime = new Double((double)(end - start) / 1000.0);
            if (statusCode != 200) {
                statusLine = method.getStatusLine();
            }
            responseBody = method.getResponseBodyAsString();
            this.logger.debug((Object)"Response received");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TestResult(new String(responseBody), e.toString(), executionTime);
        }
        return new TestResult(new String(responseBody), statusCode == 200 ? XMLReport.NOT_AVAILABLE : statusLine.getReasonPhrase(), executionTime);
    }
}

