/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.searchtester.plugin.CollectionInfo;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Util {
    static GCUBELog logger = new GCUBELog(Util.class);

    public static URL createURL(String baseAddress, String servletName) throws MalformedURLException {
        return new URL(baseAddress + servletName);
    }

    public static ArrayList<String> parseVREXML(String xml) throws Exception {
        logger.debug((Object)xml);
        Document domDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        ArrayList<String> vres = new ArrayList<String>();
        builder = factory.newDocumentBuilder();
        domDocument = builder.parse(new StringBufferInputStream(xml));
        Element root = domDocument.getDocumentElement();
        NodeList nodes = root.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (!(node instanceof Element)) continue;
            if (((Element)node).getTagName().compareTo("VRE") == 0) {
                if (!Util.checkForTestableVREs(((Element)node).getFirstChild().getNodeValue()).booleanValue()) continue;
                vres.add(((Element)node).getFirstChild().getNodeValue());
                continue;
            }
            if (((Element)node).getTagName().compareTo("VO") != 0 || !Util.checkForTestableVREs(((Element)node).getFirstChild().getNodeValue()).booleanValue()) continue;
            vres.add(((Element)node).getFirstChild().getNodeValue());
        }
        return vres;
    }

    private static Boolean checkForTestableVREs(String scope) {
        for (String vre : PluginContext.testableVREs) {
            if (!scope.contains(vre)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<CollectionInfo> parseColletionXML(String xml) {
        Document domDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        ArrayList<CollectionInfo> collections = new ArrayList<CollectionInfo>();
        try {
            builder = factory.newDocumentBuilder();
            logger.debug((Object)xml);
            InputStreamReader reader = new InputStreamReader((InputStream)new StringBufferInputStream(xml), "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            domDocument = builder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element root = domDocument.getDocumentElement();
        try {
            NodeList nodes = root.getElementsByTagName("Collection");
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                CollectionInfo col = new CollectionInfo();
                for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                    Node child = node.getChildNodes().item(i);
                    if (child instanceof Element) {
                        Element el = (Element)child;
                        if (el.getTagName().compareTo("name") == 0) {
                            logger.debug((Object)el.getFirstChild().getNodeValue());
                            col.setName(el.getFirstChild().getNodeValue());
                        } else if (el.getTagName().compareTo("colId") == 0) {
                            logger.debug((Object)el.getFirstChild().getNodeValue());
                            col.setId(el.getFirstChild().getNodeValue());
                        }
                    }
                    if (col.getName().compareTo("") == 0 || col.getId().compareTo("") == 0) continue;
                    collections.add(col);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collections;
    }

    public static String checkResults(String xml) throws Exception {
        if (xml.contains("RSRecord")) {
            return XMLReport.STATUS_OK;
        }
        return XMLReport.STATUS_ERROR_NO_RESULTS;
    }

    public static String getRandomField(ArrayList<String> fields) {
        int randomIndex = new Random().nextInt() % fields.size();
        randomIndex = Integer.signum(randomIndex) == -1 ? -randomIndex : randomIndex;
        String field = Util.removeChars(fields.get(randomIndex));
        return field;
    }

    private static String removeChars(String string) {
        String toReturn = string.replace("\"", "");
        toReturn = toReturn.replace("(", "");
        toReturn = toReturn.replace(")", "");
        toReturn = toReturn.replace(":", "");
        toReturn = toReturn.replace(";", "");
        toReturn = toReturn.replace(",", "");
        toReturn = toReturn.replace("=", "");
        toReturn = toReturn.replace("'", "");
        toReturn = toReturn.replace("<", "");
        toReturn = toReturn.replace(">", "");
        toReturn = toReturn.replace("-", "");
        return toReturn;
    }

    public static String getRandomToken(String collectionName) {
        StringTokenizer token = new StringTokenizer(collectionName);
        try {
            int i = 0;
            if (token.countTokens() == 0) {
                return "";
            }
            int randomToken = new Random().nextInt() % token.countTokens();
            int n = randomToken = Integer.signum(randomToken) == -1 ? -randomToken : randomToken;
            while (token.hasMoreElements()) {
                String tok = token.nextToken();
                if (i == randomToken) {
                    return Util.removeChars(tok);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getRandomTokenFromSchemas(CollectionInfo col) {
        String metadata = "";
        if (col.getAvailableSchemata().size() == 0) {
            return "";
        }
        for (CollectionInfo.Schema schema : col.getAvailableSchemata()) {
            metadata = col.getMetadataRecord(schema);
            if (metadata != null && (metadata = Util.getElementFromMetadata(metadata, "title")).compareTo("") != 0) continue;
        }
        return Util.getRandomToken(metadata);
    }

    public static String getRandomTermFromRandomCollection(ArrayList<CollectionInfo> collections) {
        String metadata = "";
        if (collections.size() == 0) {
            return "";
        }
        for (int i = 0; i < 10; ++i) {
            int random = new Random().nextInt() % collections.size();
            random = Integer.signum(random) == -1 ? -random : random;
            CollectionInfo col = collections.get(random);
            for (CollectionInfo.Schema schema : col.getAvailableSchemata()) {
                metadata = col.getMetadataRecord(schema);
                if (metadata != null && (metadata == null || metadata.compareTo("") == 0)) {
                    logger.debug((Object)"Empty Metadata to parse");
                    continue;
                }
                if ((metadata = Util.getElementFromMetadata(metadata, "title")) == null || metadata.compareTo("") == 0) continue;
            }
        }
        if (metadata == null || metadata.compareTo("") == 0) {
            return "";
        }
        return Util.getRandomToken(metadata);
    }

    public static String getElementFromMetadata(String metadataRecord, String tag) {
        Document domDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new StringBufferInputStream(metadataRecord), "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            domDocument = builder.parse(is);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "//*[local-name()='" + tag + "']";
            Node node = (Node)xpath.evaluate(expression, domDocument, XPathConstants.NODE);
            if (node != null && node instanceof Element) {
                return ((Element)node).getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static CollectionInfo parseColletionInfoXML(CollectionInfo collectionInfo, String string, CollectionInfo.Schema ... schema) {
        Document domDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Element root = null;
        NodeList nodes = null;
        try {
            Element el;
            Node child;
            builder = factory.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new StringBufferInputStream(string), "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            domDocument = builder.parse(is);
            root = domDocument.getDocumentElement();
            if (schema.length == 0) {
                nodes = root.getElementsByTagName("schema");
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node node = nodes.item(j);
                    String name = "";
                    String language = "";
                    for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                        Node child2 = node.getChildNodes().item(i);
                        if (child2 instanceof Element) {
                            Element el2 = (Element)child2;
                            if (el2.getTagName().compareTo("name") == 0) {
                                logger.debug((Object)el2.getFirstChild().getNodeValue());
                                name = el2.getFirstChild().getNodeValue();
                            } else if (el2.getTagName().compareTo("language") == 0) {
                                logger.debug((Object)el2.getFirstChild().getNodeValue());
                                language = el2.getFirstChild().getNodeValue();
                            }
                        }
                        if (name.compareTo("") == 0 || language.compareTo("") == 0) continue;
                        collectionInfo.addSchema(name, language);
                    }
                }
                nodes = root.getElementsByTagName("browseField");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node child3 = nodes.item(i);
                    if (!(child3 instanceof Element)) continue;
                    Element el3 = (Element)child3;
                    collectionInfo.addBrowsableField(el3.getFirstChild().getNodeValue());
                }
            }
            if ((nodes = root.getElementsByTagName("searchField")).getLength() != 0) {
                ArrayList<String> searchField = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    child = nodes.item(i);
                    if (!(child instanceof Element)) continue;
                    el = (Element)child;
                    searchField.add(el.getFirstChild().getNodeValue());
                }
                collectionInfo.addSearchableFields(schema[0], searchField);
            }
            if ((nodes = root.getElementsByTagName("sortField")).getLength() != 0) {
                ArrayList<String> sortField = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    child = nodes.item(i);
                    if (!(child instanceof Element)) continue;
                    el = (Element)child;
                    sortField.add(el.getFirstChild().getNodeValue());
                }
                collectionInfo.addSortableFields(schema[0], sortField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collectionInfo;
    }
}

