/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import org.gcube.event.publisher.Event;
import org.gcube.portal.event.publisher.lr62.model.AbstractEventPublisherBaseModelListener;
import org.gcube.portal.event.publisher.lr62.model.UserGroupRoleEvent;

public class UserGroupRoleEventPublisher
extends AbstractEventPublisherBaseModelListener<UserGroupRole> {
    protected static final Log log = LogFactoryUtil.getLog(UserGroupRoleEventPublisher.class);

    public UserGroupRoleEventPublisher() {
        log.info((Object)"New UserGroupRoleEventPublisher instance created");
    }

    public void onAfterCreate(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Group group = userGroupRole.getGroup();
            if (group.isSite() && group.isActive()) {
                log.debug((Object)"Created a site user's group role");
                UserGroupRoleEvent event = UserGroupRoleEvent.newCreatedEvent((UserGroupRole)userGroupRole, (User)userGroupRole.getUser(), (Group)group, (Role)userGroupRole.getRole());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Event is: " + event));
                }
                this.publish((Event)event);
            } else if (log.isDebugEnabled() && !group.isSite()) {
                log.debug((Object)"Created a non-site user's group role");
            } else if (log.isDebugEnabled() && group.isSite() && !group.isActive()) {
                log.debug((Object)"Created a user's group role for a disabled group");
            }
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Cannot get related model objects", e);
        }
    }

    public void onBeforeRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Group group = userGroupRole.getGroup();
            if (group.isSite() && group.isActive()) {
                log.debug((Object)"Deleted a site user's group role");
                UserGroupRoleEvent event = UserGroupRoleEvent.newDeletedEvent((UserGroupRole)userGroupRole, (User)userGroupRole.getUser(), (Group)group, (Role)userGroupRole.getRole());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Event is: " + event));
                }
                this.publish((Event)event);
            } else if (log.isDebugEnabled() && !group.isSite()) {
                log.debug((Object)"Deleted a non-site user's group role");
            } else if (log.isDebugEnabled() && group.isSite() && !group.isActive()) {
                log.debug((Object)"Deleted a user's group role for a disabled group");
            }
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Cannot get related model objects", e);
        }
    }

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onAfterRemove(UserGroupRole userGroupRole) throws ModelListenerException {
    }

    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onAfterUpdate(UserGroupRole userGroupRole) throws ModelListenerException {
    }

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onBeforeCreate(UserGroupRole userGroupRole) throws ModelListenerException {
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onBeforeUpdate(UserGroupRole userGroupRole) throws ModelListenerException {
    }
}

