package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

/**
 * SG4 token resolver using Secret + AuthorizedTasks via reflection.
 * - Avoids ScopeProvider (deprecated).
 * - Does not require compile-time imports of gCube authorization packages.
 */
public class TokenUtil {
    private static final Log _log = LogFactoryUtil.getLog(TokenUtil.class);

    public static String resolveUserToken(String username, String scope) {
        try {
            // Obtain Secret at runtime (reflection)
            Class<?> secretProviderClass = Class.forName("org.gcube.common.security.providers.SecretManagerProvider");
            Object secret = secretProviderClass.getMethod("get").invoke(null);

            Class<?> authorizedTasksClass = Class.forName("org.gcube.common.security.AuthorizedTasks");
            Class<?> secretClass = Class.forName("org.gcube.common.security.Secret");

            // Callable that attempts AuthorizationService operations via reflection
            Callable<String> task = new Callable<String>() {
                @Override
                public String call() throws Exception {
                    try {
                        Class<?> authServiceClass = Class.forName("org.gcube.common.authorization.library.AuthorizationService");
                        Object authService = authServiceClass.getDeclaredConstructor().newInstance();

                        // First try: resolve existing token
                        try {
                            Method resolveMethod = authServiceClass.getMethod("resolveTokenByUserAndContext", String.class, String.class);
                            return (String) resolveMethod.invoke(authService, username, scope);
                        } catch (Throwable notFound) {
                            // Fallback: try generateUserToken(UserInfo, String)
                            try {
                                Class<?> userInfoClass = Class.forName("org.gcube.common.authorization.library.provider.UserInfo");
                                List<?> roles = new ArrayList<>();
                                Object userInfo = userInfoClass.getConstructor(String.class, List.class).newInstance(username, roles);
                                Method genUserToken = authServiceClass.getMethod("generateUserToken", userInfoClass, String.class);
                                String token = (String) genUserToken.invoke(authService, userInfo, scope);
                                _log.debug("generateUserToken OK for " + username + " in scope " + scope);
                                return token;
                            } catch (Throwable tryAlt) {
                                // Fallback: try generateAuthorizationToken(String, String)
                                try {
                                    Method genAuthToken = authServiceClass.getMethod("generateAuthorizationToken", String.class, String.class);
                                    String token = (String) genAuthToken.invoke(authService, username, scope);
                                    _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
                                    return token;
                                } catch (Throwable finalFail) {
                                    _log.error("AuthorizationService token generation failed for user " + username + " in scope " + scope, finalFail);
                                    return null;
                                }
                            }
                        }
                    } catch (Throwable e) {
                        _log.error("Error invoking AuthorizationService via reflection", e);
                        return null;
                    }
                }
            };

            Object token = authorizedTasksClass.getMethod("executeSafely", Callable.class, secretClass)
                .invoke(null, task, secret);

            return token != null ? (String) token : generateAuthorizationToken(username, scope);
        } catch (Throwable t) {
            _log.warn("gCube Secret/AuthorizedTasks not available, fallback token for user=" + username + " scope=" + scope);
            return generateAuthorizationToken(username, scope);
        }
    }

    private static String generateAuthorizationToken(String username, String scope) {
        // Fallback-only: placeholder token when gCube libs are not available
        return "token_" + username + "_" + scope + "_" + System.currentTimeMillis();
    }
}