/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gcube.portal.event.publisher.lr74.model.TokenUtil;

public class EventPublisherFacade {
    private static final Log _log = LogFactoryUtil.getLog(EventPublisherFacade.class);
    private static final EventPublisherFacade INSTANCE = new EventPublisherFacade();

    public static EventPublisherFacade getInstance() {
        return INSTANCE;
    }

    public void onStartup() throws Exception {
        this.publish("STARTUP", null, null);
    }

    public void onShutdown() throws Exception {
        this.publish("SHUTDOWN", null, null);
    }

    public void onPostLogin(LifecycleEvent event) throws Exception {
        HttpServletRequest request = event.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null || themeDisplay.getUser() == null) {
            _log.debug((Object)"ThemeDisplay not available during post-login; skipping event publish");
            return;
        }
        String username = themeDisplay.getUser().getScreenName();
        String scope = themeDisplay.getScopeGroup() != null ? themeDisplay.getScopeGroup().getGroupKey() : null;
        String token = TokenUtil.resolveUserToken(username, scope);
        this.publish("LOGIN", username, token);
    }

    public void onPreLogout(LifecycleEvent event) throws Exception {
        HttpServletRequest request = event.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String username = themeDisplay.getUser().getScreenName();
        this.publish("LOGOUT", username, null);
    }

    private void publish(String type, String username, String token) {
        try {
            _log.info((Object)("Publishing event type=" + type + " user=" + username));
            try {
                Class<?> processorClass = Class.forName("org.gcube.event.publisher.EventProcessor");
                processorClass.getMethod("process", String.class, String.class, String.class).invoke(null, type, username, token);
                _log.debug((Object)"Event published successfully via EventProcessor");
                return;
            }
            catch (ClassNotFoundException cnf) {
                _log.debug((Object)"EventProcessor not on classpath, trying EventPublisher");
                try {
                    Class<?> publisherClass = Class.forName("org.gcube.event.publisher.EventPublisher");
                    Object publisher = publisherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    publisherClass.getMethod("publish", String.class, String.class, String.class).invoke(publisher, type, username, token);
                    _log.debug((Object)"Event published successfully via EventPublisher");
                    return;
                }
                catch (ClassNotFoundException cnf2) {
                    _log.info((Object)("gCube event publisher libraries not available - event logged only: type=" + type + " user=" + username));
                    return;
                }
            }
        }
        catch (Throwable t) {
            _log.warn((Object)("Event publish attempt failed for type=" + type + " user=" + username + ": " + t.getMessage()));
            return;
        }
    }

    public void publish(String eventName, Map<String, Object> payload) {
        try {
            _log.info((Object)("Publishing event name=" + eventName + " payload keys=" + String.valueOf(payload != null ? payload.keySet() : "none")));
            try {
                Class<?> processorClass = Class.forName("org.gcube.event.publisher.EventProcessor");
                processorClass.getMethod("process", String.class, Map.class).invoke(null, eventName, payload);
                _log.debug((Object)"Model event published successfully via EventProcessor");
                return;
            }
            catch (ClassNotFoundException cnf) {
                _log.debug((Object)"EventProcessor not on classpath for Map payload, trying EventPublisher");
                try {
                    Class<?> publisherClass = Class.forName("org.gcube.event.publisher.EventPublisher");
                    Object publisher = publisherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    publisherClass.getMethod("publish", String.class, Map.class).invoke(publisher, eventName, payload);
                    _log.debug((Object)"Model event published successfully via EventPublisher");
                    return;
                }
                catch (ClassNotFoundException cnf2) {
                    _log.info((Object)("gCube event publisher libraries not available - model event logged only: " + eventName));
                    return;
                }
            }
        }
        catch (Throwable t) {
            _log.warn((Object)("Model event publish attempt failed for event=" + eventName + ": " + t.getMessage()));
            return;
        }
    }
}

