package org.gcube.portal.invites;

import java.util.Date;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.gcube.common.portal.PortalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * A class for sending email
 * 
 * @author M. Assante
 *
 */
public class EmailNotification {
	/**
	 * The sender of the email
	 */
	private String emailSender;

	/**
	 * The recipients of the email
	 */
	private String emailrecipients[];

	/**
	 * Email's subject
	 */
	private String emailSubject;

	/**
	 * Email's body message
	 */
	private String emailBody;
	
	private String portalName;

	/** Logger */
	private static Logger _log = LoggerFactory.getLogger(EmailNotification.class);	

	/**
	 * Class's constructor
	 * 
	 * @param sender 
	 * @param recipients 
	 * @param subject 
	 * @param body 
	 */
	public EmailNotification(String sender, String recipients[], String subject, String body) {
		this.emailSender = PortalContext.getConfiguration().getSenderEmail();
		this.emailrecipients = recipients;
		this.emailSubject = subject;
		this.emailBody = body;
		this.portalName = PortalContext.getConfiguration().getGatewayName();
	}

	public void sendEmail() {
		Properties props = System.getProperties();
		String mailServiceHost = "localhost";
		props.put("mail.smtp.host", mailServiceHost);
		String mailServicePort = "25";
		props.put("mail.smtp.port", mailServicePort);
		Session session = Session.getDefaultInstance(props, null);
		session.setDebug(true);
		Message mimeMessage = new MimeMessage(session);

		try {
			// EMAIL SENDER
			Address from = new InternetAddress(emailSender, portalName);
			mimeMessage.setHeader("Content-Type", "text/html; charset=UTF-8");
			mimeMessage.setFrom(from);

			// EMAIL RECIPIENTS
			for (int i=0; i<emailrecipients.length; i++) {
				Address address = new InternetAddress(emailrecipients[i]);
				mimeMessage.addRecipient(Message.RecipientType.TO, address);

			}

			mimeMessage.setSubject(emailSubject);
			// mimeMessage.setText(emailBody);
			mimeMessage.setContent(emailBody, "text/html; charset=UTF-8");
			mimeMessage.setSentDate(new Date());
			Transport.send(mimeMessage);
		} catch (Exception e) {
			e.printStackTrace();
			_log.error("Failed to send the email message.", e);
		}
	}
	
	
}


