package com.test;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.Email;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.webserver.WebServerServletTokenUtil;

/**
 * Portlet implementation class UsersManagementTest
 */
public class UsersManagementTest extends GenericPortlet {
	private static Log log = LogFactoryUtil.getLog(UsersManagementTest.class);
	public void init() {
		viewTemplate = getInitParameter("view-template");
	}
	public static final String PUBLIC_LAYOUT_NAME = "Infrastructure gateway";
	public static final String GUEST_COMMUNITY_NAME = "Guest";
	private static String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
	private static String CATEGORY_NAME = "Portal";
	
	private static String LEGACY_GATEWAY_NAME = "D4Science Infrastructure Gateway";
	private static String DEVELOPERS_GATEWAY_NAME = "D4Science Developers";
	

	public void doView(	RenderRequest renderRequest, RenderResponse renderResponse)	throws IOException, PortletException {
		try {
			List<GCubeGroup> toReturn = getinfrastructureGatewaySiteGroupIds();
			String infraName = PortalContext.getConfiguration().getInfrastructureName();
			System.out.println("Filtered ...");
			for (GCubeGroup gCubeGroup : toReturn) {
				if (! (gCubeGroup.getGroupName().equalsIgnoreCase(LEGACY_GATEWAY_NAME) 
						&& gCubeGroup.getGroupName().equalsIgnoreCase(DEVELOPERS_GATEWAY_NAME)
						&& gCubeGroup.getGroupName().equalsIgnoreCase(infraName)) ) {
					toReturn.add(gCubeGroup);
					System.out.println(gCubeGroup.getGroupName());
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}



	public List<GCubeGroup> getinfrastructureGatewaySiteGroupIds() {
		List<GCubeGroup> listToFilter = new LiferayGroupManager().getGateways();
		for (GCubeGroup gCubeGroup : listToFilter) {
			System.out.println("Site: " + gCubeGroup.getGroupName() + " id="+gCubeGroup.getGroupId());
		}
		return listToFilter;
	}


	public List<GCubeUser> listUsersIndexedVersion() throws UserManagementSystemException {
		List<GCubeUser> toReturn = new ArrayList<GCubeUser>();
		try {
			List<User> lrUsers = UserLocalServiceUtil.getUsers(QueryUtil.ALL_POS,  QueryUtil.ALL_POS);
			for (User user : lrUsers) {
				if (user.isActive())
					toReturn.add(mapLRUser(user));
			}
		} catch (SystemException e) {
			throw new UserManagementSystemException(e.getMessage(), e);
		} catch (PortalException e) {
			e.printStackTrace();
		}
		return toReturn;
	}

	public List<GCubeUser> listUsers() throws UserManagementSystemException {
		List<GCubeUser> toReturn = new ArrayList<GCubeUser>();
		try {
			OrderByComparator comparator = OrderByComparatorFactoryUtil.create("User_", "screenname", true);
			List<User> lrUsers = UserLocalServiceUtil.search(ManagementUtils.getCompany().getCompanyId(), "", 0, null, QueryUtil.ALL_POS, QueryUtil.ALL_POS, comparator);
			for (User user : lrUsers) {
				if (user.isActive())
					toReturn.add(mapLRUser(user));
			}
		} catch (SystemException e) {
			throw new UserManagementSystemException(e.getMessage(), e);
		} catch (PortalException e) {
			e.printStackTrace();
		}
		return toReturn;
	}

	//simple user mapping
	private GCubeUser mapLRUser(User u) throws PortalException, SystemException {
		if (u != null) {
			List<Email> emails = new ArrayList<Email>();
			for (EmailAddress e : u.getEmailAddresses()) {
				emails.add(new Email(e.getAddress(), e.getType().toString(), e.isPrimary()));
			}
			String locationIndustry = "";
			try {
				locationIndustry = (String) readCustomAttr(u.getUserId(), CustomAttributeKeys.USER_LOCATION_INDUSTRY.getKeyName());
			} catch (UserRetrievalFault e1) {
				e1.printStackTrace();
			}
			return new GCubeUser(
					u.getUserId(), 
					u.getScreenName(), 
					u.getEmailAddress(), 
					u.getFirstName(),
					u.getMiddleName(),
					u.getLastName(),
					u.getFullName(),
					u.getCreateDate().getTime(),
					getUserAvatarAbsoluteURL(u),
					u.isMale(),
					u.getJobTitle(),
					locationIndustry,
					emails);
		}
		else 
			return null;
	}

	public Serializable readCustomAttr(long userId, String attributeKey) throws UserRetrievalFault {
		try {
			doAsAdmin();
			User u = UserLocalServiceUtil.getUser(userId);
			if (u.getExpandoBridge().hasAttribute(attributeKey)) {
				//_log.debug("User Attribute found: " + attributeKey + " trying read value");
				return u.getExpandoBridge().getAttribute(attributeKey);
			} else
				return null;
		} catch (PortalException e1) {
			throw new UserRetrievalFault("User not existing (I think you better check)", e1);
		} catch (Exception e) {
			e.printStackTrace();
		} 
		return null;
	}
	private void doAsAdmin() {
		try {			
			User admin = getAdmin();
			long userId = admin.getUserId();
			PrincipalThreadLocal.setName(userId);
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(UserLocalServiceUtil.getUser(userId));
			PermissionThreadLocal.setPermissionChecker(permissionChecker); 
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public static User getAdmin() {
		final long companyId = PortalUtil.getDefaultCompanyId();
		Role role = null;
		try {
			role = getRoleById(companyId, RoleConstants.ADMINISTRATOR);
			for (final User admin : UserLocalServiceUtil.getRoleUsers(role.getRoleId())) {
				if (admin.isActive())
					return admin;
			}
		} catch (final Exception e) {
			_log.error("Utils::getAdmin Exception", e);
		}
		return null;
	}
	public static Role getRoleById(final long companyId, final String roleStrId) {
		try {
			return RoleLocalServiceUtil.getRole(companyId, roleStrId);
		} catch (final Exception e) {
			_log.error("Utils::getRoleById Exception", e);
		}
		return null;
	}
	/**
	 * 
	 * @param u
	 * @return the absolute path of the avatar URL comprising security token e.g. /image/user_male_portrait?img_id=22910&img_id_token=0RJ5WkeDV9F9bETGlqzb7LahygM%3D&t=1458899199747
	 * @throws PortalException
	 * @throws SystemException
	 */
	private static String getUserAvatarAbsoluteURL(User u) throws PortalException, SystemException {
		String pictureBaseURL = u.isMale() ? "/image/user_male_portrait?img_id=" : "/image/user_female_portrait?img_id=";
		String img_id_token = HttpUtil.encodeURL(DigesterUtil.digest(u.getUuid()));
		String token = WebServerServletTokenUtil.getToken(u.getPortraitId());
		return pictureBaseURL+u.getPortraitId()+"&img_id_token="+img_id_token+"&t="+token;
	}




	/**
	 * {@inheritDoc}
	 */

	public Set<GCubeGroup> listGroupsByUserAndSite(long userId, final String serverName) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
		Set<GCubeGroup> toReturn = new HashSet<>();
		GroupManager gm = new LiferayGroupManager();
		try {
			List<VirtualGroup> currSiteVirtualGroups = getVirtualGroups(ManagementUtils.getSiteGroupIdFromServletRequest(serverName));
			System.out.println("currSiteVirtualGroups");
			for (VirtualGroup virtualGroup : currSiteVirtualGroups) {
				System.out.println(virtualGroup);
			}

			for (GCubeGroup userGroup : gm.listGroupsByUser(userId)) {
				if (gm.isVRE(userGroup.getGroupId())) {
					System.out.println("userGroup="+userGroup.getGroupName());
					for (VirtualGroup currSiteVGroup : currSiteVirtualGroups) {
						List<VirtualGroup> vGroups = getVirtualGroups(userGroup.getGroupId());
						for (VirtualGroup virtualGroup : vGroups) {
							if (virtualGroup.getName().compareTo(currSiteVGroup.getName()) == 0) 
								toReturn.add(userGroup);
						}						
					}
				}
			}

			System.out.println("*** returned VREs for user id=" + userId);
			for (GCubeGroup g : toReturn) {
				System.out.println(g.getGroupName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}		
		return toReturn;
	}

	public List<VirtualGroup> getVirtualGroups(long actualGroupId) throws GroupRetrievalFault, VirtualGroupNotExistingException {
		List<VirtualGroup> toReturn = new ArrayList<VirtualGroup>();
		try {
			long userId = LiferayUserManager.getAdmin().getUserId();
			PrincipalThreadLocal.setName(userId);
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(UserLocalServiceUtil.getUser(userId));
			PermissionThreadLocal.setPermissionChecker(permissionChecker); 
			Group site = GroupLocalServiceUtil.getGroup(actualGroupId);
			if (site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()) == null ||  site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()).equals("")) {
				String warningMessage = String.format("Attribute %s not initialized.", CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
				_log.warn(warningMessage); 
				throw new VirtualGroupNotExistingException(warningMessage);
			} else {
				String[] values = (String[]) site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());  
				VirtualGroup toAdd = new VirtualGroup();
				if (values != null && values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						toAdd = new VirtualGroup();
						String[] splits = values[i].split("\\|");
						toAdd.setName(splits[0]);
						toAdd.setDescription(splits[1]);
						toReturn.add(toAdd);
					}					
				} else {
					toAdd.setName("NoVirtualGroupAssigned");
					toAdd.setDescription("NoVirtualGroupDescription");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return toReturn;
	}




	protected void include(
			String path, RenderRequest renderRequest,
			RenderResponse renderResponse)
					throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher =
				getPortletContext().getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			_log.error(path + " is not a valid include");
		}
		else {
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}

	protected String viewTemplate;

	private static Log _log = LogFactoryUtil.getLog(UsersManagementTest.class);

}
