/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.Email;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsersManagementTest
extends GenericPortlet {
    private static Log log = LogFactoryUtil.getLog(UsersManagementTest.class);
    public static final String PUBLIC_LAYOUT_NAME = "Infrastructure gateway";
    public static final String GUEST_COMMUNITY_NAME = "Guest";
    private static String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
    private static String CATEGORY_NAME = "Portal";
    private static String LEGACY_GATEWAY_NAME = "D4Science Infrastructure Gateway";
    private static String DEVELOPERS_GATEWAY_NAME = "D4Science Developers";
    protected String viewTemplate;
    private static Log _log = LogFactoryUtil.getLog(UsersManagementTest.class);

    public void init() {
        this.viewTemplate = this.getInitParameter("view-template");
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            List toReturn = this.getinfrastructureGatewaySiteGroupIds();
            String infraName = PortalContext.getConfiguration().getInfrastructureName();
            System.out.println("Filtered ...");
            for (GCubeGroup gCubeGroup : toReturn) {
                if (gCubeGroup.getGroupName().equalsIgnoreCase(LEGACY_GATEWAY_NAME) && gCubeGroup.getGroupName().equalsIgnoreCase(DEVELOPERS_GATEWAY_NAME) && gCubeGroup.getGroupName().equalsIgnoreCase(infraName)) continue;
                toReturn.add(gCubeGroup);
                System.out.println(gCubeGroup.getGroupName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<GCubeGroup> getinfrastructureGatewaySiteGroupIds() {
        List listToFilter = new LiferayGroupManager().getGateways();
        for (GCubeGroup gCubeGroup : listToFilter) {
            System.out.println("Site: " + gCubeGroup.getGroupName() + " id=" + gCubeGroup.getGroupId());
        }
        return listToFilter;
    }

    public List<GCubeUser> listUsersIndexedVersion() throws UserManagementSystemException {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            List lrUsers = UserLocalServiceUtil.getUsers((int)-1, (int)-1);
            for (User user : lrUsers) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public List<GCubeUser> listUsers() throws UserManagementSystemException {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            OrderByComparator comparator = OrderByComparatorFactoryUtil.create((String)"User_", (Object[])new Object[]{"screenname", true});
            List lrUsers = UserLocalServiceUtil.search((long)ManagementUtils.getCompany().getCompanyId(), (String)"", (int)0, null, (int)-1, (int)-1, (OrderByComparator)comparator);
            for (User user : lrUsers) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private GCubeUser mapLRUser(User u) throws PortalException, SystemException {
        if (u != null) {
            ArrayList<Email> emails = new ArrayList<Email>();
            for (EmailAddress e : u.getEmailAddresses()) {
                emails.add(new Email(e.getAddress(), e.getType().toString(), e.isPrimary()));
            }
            String locationIndustry = "";
            try {
                locationIndustry = (String)((Object)this.readCustomAttr(u.getUserId(), CustomAttributeKeys.USER_LOCATION_INDUSTRY.getKeyName()));
            }
            catch (UserRetrievalFault e1) {
                e1.printStackTrace();
            }
            return new GCubeUser(u.getUserId(), u.getScreenName(), u.getEmailAddress(), u.getFirstName(), u.getMiddleName(), u.getLastName(), u.getFullName(), u.getCreateDate().getTime(), UsersManagementTest.getUserAvatarAbsoluteURL((User)u), u.isMale(), u.getJobTitle(), locationIndustry, emails);
        }
        return null;
    }

    public Serializable readCustomAttr(long userId, String attributeKey) throws UserRetrievalFault {
        try {
            this.doAsAdmin();
            User u = UserLocalServiceUtil.getUser((long)userId);
            if (u.getExpandoBridge().hasAttribute(attributeKey)) {
                return u.getExpandoBridge().getAttribute(attributeKey);
            }
            return null;
        }
        catch (PortalException e1) {
            throw new UserRetrievalFault("User not existing (I think you better check)", e1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void doAsAdmin() {
        try {
            User admin = UsersManagementTest.getAdmin();
            long userId = admin.getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static User getAdmin() {
        long companyId = PortalUtil.getDefaultCompanyId();
        Role role = null;
        try {
            role = UsersManagementTest.getRoleById((long)companyId, (String)"Administrator");
            for (User admin : UserLocalServiceUtil.getRoleUsers((long)role.getRoleId())) {
                if (!admin.isActive()) continue;
                return admin;
            }
        }
        catch (Exception e) {
            _log.error((Object)"Utils::getAdmin Exception", (Throwable)e);
        }
        return null;
    }

    public static Role getRoleById(long companyId, String roleStrId) {
        try {
            return RoleLocalServiceUtil.getRole((long)companyId, (String)roleStrId);
        }
        catch (Exception e) {
            _log.error((Object)"Utils::getRoleById Exception", (Throwable)e);
            return null;
        }
    }

    private static String getUserAvatarAbsoluteURL(User u) throws PortalException, SystemException {
        String pictureBaseURL = u.isMale() ? "/image/user_male_portrait?img_id=" : "/image/user_female_portrait?img_id=";
        String img_id_token = HttpUtil.encodeURL((String)DigesterUtil.digest((String)u.getUuid()));
        String token = WebServerServletTokenUtil.getToken((long)u.getPortraitId());
        return String.valueOf(pictureBaseURL) + u.getPortraitId() + "&img_id_token=" + img_id_token + "&t=" + token;
    }

    public Set<GCubeGroup> listGroupsByUserAndSite(long userId, String serverName) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
        HashSet<GCubeGroup> toReturn = new HashSet<GCubeGroup>();
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            List currSiteVirtualGroups = this.getVirtualGroups(ManagementUtils.getSiteGroupIdFromServletRequest((String)serverName));
            System.out.println("currSiteVirtualGroups");
            for (VirtualGroup virtualGroup : currSiteVirtualGroups) {
                System.out.println(virtualGroup);
            }
            for (GCubeGroup userGroup : gm.listGroupsByUser(userId)) {
                if (!gm.isVRE(userGroup.getGroupId()).booleanValue()) continue;
                System.out.println("userGroup=" + userGroup.getGroupName());
                for (VirtualGroup currSiteVGroup : currSiteVirtualGroups) {
                    List vGroups = this.getVirtualGroups(userGroup.getGroupId());
                    for (VirtualGroup virtualGroup : vGroups) {
                        if (virtualGroup.getName().compareTo(currSiteVGroup.getName()) != 0) continue;
                        toReturn.add(userGroup);
                    }
                }
            }
            System.out.println("*** returned VREs for user id=" + userId);
            for (GCubeGroup g : toReturn) {
                System.out.println(g.getGroupName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public List<VirtualGroup> getVirtualGroups(long actualGroupId) throws GroupRetrievalFault, VirtualGroupNotExistingException {
        ArrayList<VirtualGroup> toReturn = new ArrayList<VirtualGroup>();
        try {
            long userId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            Group site = GroupLocalServiceUtil.getGroup((long)actualGroupId);
            if (site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()) == null || site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()).equals("")) {
                String warningMessage = String.format("Attribute %s not initialized.", CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
                _log.warn((Object)warningMessage);
                throw new VirtualGroupNotExistingException(warningMessage);
            }
            String[] values = (String[])site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
            VirtualGroup toAdd = new VirtualGroup();
            if (values != null && values.length > 0) {
                int i = 0;
                while (i < values.length) {
                    toAdd = new VirtualGroup();
                    String[] splits = values[i].split("\\|");
                    toAdd.setName(splits[0]);
                    toAdd.setDescription(splits[1]);
                    toReturn.add(toAdd);
                    ++i;
                }
            } else {
                toAdd.setName("NoVirtualGroupAssigned");
                toAdd.setDescription("NoVirtualGroupDescription");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(renderRequest, renderResponse);
        }
    }
}

