package org.gcube.portal.usersaccount;

import org.gcube.portal.notifications.thread.NewUserAccountNotificationThread;
import org.gcube.portal.removeaccount.thread.RemoveUserTokenFromInfraThread;
import org.gcube.portal.removeaccount.thread.RemovedUserAccountThread;
import org.gcube.portal.removeaccount.thread.RemovedUserFromLDAPThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.User;
/**
 * 
 * @author Massimiliano Assante, CNR-ISTI
 *
 * Model Listeners are used to listen for events on models and do something in response. 
 * They’re similar in concept to custom action hooks, which perform actions in response to portal events (user login, for example). 
 * Model listeners implement the ModelListener interface.
 * 
 * @see https://dev.liferay.com/develop/tutorials/-/knowledge_base/6-2/creating-model-listeners
 */
public class MyCreateUserAccountListener extends BaseModelListener<User> {
	private static final Logger _log = LoggerFactory.getLogger(MyCreateUserAccountListener.class);
	final String SUBJECT = "New user account notification";

	@Override
	public void onAfterCreate(User user) throws ModelListenerException {
		_log.info("onAfterCreate NewUserAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
		Thread emailManagersThread = new Thread(new NewUserAccountNotificationThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
		emailManagersThread.start();

		Thread WorkspaceAccountCreationThread = new Thread(new WorkspaceCreateAccountThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
		WorkspaceAccountCreationThread.start();
	}

	@Override
	public void onBeforeRemove(User user) throws ModelListenerException {
		_log.info("onBeforeRemove userAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
		String username2Delete = user.getScreenName();
		_log.info("Trying to remove user from JCR and not notify infra-managers ...");
		try {
			Thread dropUserWorkspaceThread = new Thread(new RemovedUserAccountThread(user.getUserId(), username2Delete));
			dropUserWorkspaceThread.start();
			_log.info("Trying to remove user from LDAP ...");
			Thread removeFromLDAPThread = new Thread(new RemovedUserFromLDAPThread(username2Delete));
			removeFromLDAPThread.start();
			
			_log.info("Trying to remove user from Auth ...");
			Thread deleteAllUserAuthThread = new Thread(new RemoveUserTokenFromInfraThread(username2Delete));
			deleteAllUserAuthThread.start();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//	@Override
	//    public void onAfterRemove(User user)





}