/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.removeaccount.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

public class RemoveUserFromJCR {
    private static Log _log = LogFactoryUtil.getLog(RemoveUserFromJCR.class);
    private String username2Delete;
    private GroupManager gm;
    private UserManager uMan;
    private RoleManager rm;

    public RemoveUserFromJCR(String username2Delete, GroupManager gm, UserManager uMan) {
        this.username2Delete = username2Delete;
        this.gm = gm;
        this.uMan = uMan;
        this.rm = new LiferayRoleManager();
    }

    public boolean remove() {
        try {
            _log.debug((Object)("in RemoveUserFromJCR remove() for " + this.username2Delete));
            String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
            long groupId = this.gm.getGroupIdFromInfrastructureScope(infraContext);
            long roleId = this.rm.getRoleId("Infrastructure-Manager", groupId);
            List users = this.uMan.listUsersByGroupAndRole(groupId, roleId);
            if (users.isEmpty()) {
                _log.error((Object)("Cannot delete the user: there is no user having role Infrastructure-Manager on context: " + infraContext));
                return false;
            }
            GCubeUser theAdmin = (GCubeUser)users.get(0);
            String adminUsername = theAdmin.getUsername();
            String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
            List theAdminRoles = this.rm.listRolesByUserAndGroup(theAdmin.getUserId(), groupId);
            ArrayList<String> rolesString = new ArrayList<String>();
            for (GCubeRole gCubeRole : theAdminRoles) {
                rolesString.add(gCubeRole.getRoleName());
            }
            Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
            SecurityTokenProvider.instance.set(theAdminToken);
            _log.debug((Object)("Autorising drop workspace with infra manager token of " + theAdminToken));
            StorageHubClient shc = new StorageHubClient();
            _log.debug((Object)("BEFORE stohub.deleteUserAccount " + this.username2Delete));
            shc.deleteUserAccount(this.username2Delete);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error((Object)("Could not delete " + this.username2Delete + " from JCR  an error occurred on the service"));
            return false;
        }
    }
}

