/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.usersaccount;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkspaceCreateAccountThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(WorkspaceCreateAccountThread.class);
    public static final String AUTORISED_INFRA_ROLE = "Infrastructure-Manager";
    private String newUserUserName;

    public WorkspaceCreateAccountThread(String newUserUserName, String newUserFullName, String newUserEmailAddress) {
        this.newUserUserName = newUserUserName;
        _log.info("Calling StorageHub for Workspace creation to new user: " + newUserUserName + " (" + newUserFullName + ")");
    }

    @Override
    public void run() {
        WorkspaceCreateAccountThread.getWS((String)this.newUserUserName, (String)("/" + PortalContext.getConfiguration().getInfrastructureName()));
    }

    public static void getWS(String currentUsername, String context) {
        String username = currentUsername;
        String authorizationToken = PortalContext.getConfiguration().getCurrentUserToken(context, username);
        SecurityTokenProvider.instance.set(authorizationToken);
        ScopeProvider.instance.set(context);
        String previousToken = authorizationToken;
        try {
            String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
            long groupId = new LiferayGroupManager().getGroupIdFromInfrastructureScope(infraContext);
            LiferayRoleManager rm = new LiferayRoleManager();
            LiferayUserManager uMan = new LiferayUserManager();
            long roleId = rm.getRoleId("Infrastructure-Manager", groupId);
            List users = uMan.listUsersByGroupAndRole(groupId, roleId);
            if (users.isEmpty()) {
                _log.error("Cannot create this user account on storageHub there is no user having role {} on context {}", (Object)"Infrastructure-Manager", (Object)infraContext);
                return;
            }
            GCubeUser theAdmin = (GCubeUser)users.get(0);
            String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, theAdmin.getUsername());
            List theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), groupId);
            ArrayList<String> rolesString = new ArrayList<String>();
            for (GCubeRole gCubeRole : theAdminRoles) {
                rolesString.add(gCubeRole.getRoleName());
            }
            Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
            SecurityTokenProvider.instance.set(theAdminToken);
            StorageHubClient shc = new StorageHubClient();
            shc.createUserAccount(currentUsername);
            SecurityTokenProvider.instance.set(previousToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            SecurityTokenProvider.instance.set(previousToken);
            return;
        }
    }
}

