package org.gcube.portal.mailing.templates;

import java.util.Base64;
import java.util.Date;

import org.gcube.common.portal.mailing.templates.AbstractTemplate;
import org.gcube.common.portal.mailing.templates.Template;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

/**
 * 
 * @author Massimiliano Assante, CNR-ISTI
 *
 */
public class TemplateUserAcceptedInvite extends AbstractTemplate implements Template {
	private final static String encodedTemplateHTML = "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";
	private final static String encodedTemplateTEXT = "e3tHQVRFV0FZX05BTUV9fQ0KLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ0Ke3tVU0VSX0ZVTExOQU1FfX0gaGFzIGFjY2VwdGVkIHRoZSBpbnZpdGUgb24ge3tTRUxFQ1RFRF9WUkVfTkFNRX19IFZSRS4NCg0KRnVydGhlciBpbmZvIGFib3V0IHt7VVNFUl9GVUxMTkFNRX19Og0KDQpFbWFpbDoge3tVU0VSX0VNQUlMfX0NClVzZXJuYW1lOiB7e1VTRVJfSUR9fQ0KDQoNCllvdSByZWNlaXZlZCB0aGlzIGVtYWlsIGJlY2F1c2UgeW91IGFyZSBhIG1hbmFnZXIgb2Yge3tTRUxFQ1RFRF9WUkVfTkFNRX19Lg0KVGhlIGludml0ZSB3YXMgc2VudCBieSB7e1VTRVJfV0hPX0lOVklURUR9fSAoe3tVU0VSX1dIT19JTlZJVEVEX1VTRVJOQU1FfX0pIG9uIHt7SU5WSVRFX0RBVEV9fS4=";

	private GCubeUser theAcceptingUser;
	private String theUserWhoInvitedFullname;
	private String theUserWhoInvitedUsername;
	private String theVREName;
	private Date inviteDate;
	/**
	 * 
	 * @param theRegisteredUser
	 * @param theVRE
	 * @param optionalMessage
	 * @param gatewayName
	 * @param gatewayURL
	 */
	public TemplateUserAcceptedInvite(GCubeUser theAcceptingUser, String theVREName, String theUserWhoInvitedFullname, String theUserWhoInvitedUsername, Date inviteDate, String gatewayName, String gatewayURL) {
		super(gatewayName, gatewayURL);
		this.theAcceptingUser = theAcceptingUser;
		this.theVREName = theVREName;
		this.theUserWhoInvitedFullname = theUserWhoInvitedFullname;
		this.theUserWhoInvitedUsername = theUserWhoInvitedUsername;
		this.inviteDate = inviteDate;
	}

	@Override
	public String compile(String templateContent) {

		String userAvatarURL = getGatewayURL()+this.theAcceptingUser.getUserAvatarURL();

		return new String(Base64.getDecoder().decode(templateContent))
				.replace("{{SELECTED_VRE_NAME}}", theVREName)
				.replace("{{USER_AVATAR_URL}}", userAvatarURL)
				.replace("{{USER_WHO_INVITED}}", theUserWhoInvitedFullname)
				.replace("{{USER_WHO_INVITED_USERNAME}}", theUserWhoInvitedUsername)
				.replace("{{GATEWAY_LOGO:URL}}", getGatewayLogoURL())			
				.replace("{{GATEWAY_NAME}}", getGatewayName())
				.replace("{{USER_EMAIL}}", theAcceptingUser.getEmail())
				.replace("{{USER_ID}}", theAcceptingUser.getUsername())
				.replace("{{USER_FULLNAME}}", theAcceptingUser.getFullname())
				.replace("{{INVITE_DATE}}", this.inviteDate.toString());
	}

	@Override
	public String getTextHTML() {
		return compile(encodedTemplateHTML);
	}

	@Override
	public String getTextPLAIN() {
		return compile(encodedTemplateTEXT);
	}
}
