package org.gcube.portal.oauth.cache;


import java.io.Serializable;

/**
 * A cache bean object for oauth support
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 * @author Massimiliano Assante, National Research Council of Italy (CNR) - ISTI
 */
@SuppressWarnings("serial")
public class CacheBean implements Serializable {

	private String token;
	private String scope;
	private String redirectUri;
	private String clientId;
	
	public CacheBean() {
		super();
	}

	/**
	 * @param token
	 * @param scope
	 * @param redirectUri
	 * @param clientId
	 * @param insertTime
	 */
	public CacheBean(String token, String scope, String redirectUri, String clientId) {
		super();
		this.token = token;
		this.scope = scope;
		this.redirectUri = redirectUri;
		this.clientId = clientId;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getRedirectUri() {
		return redirectUri;
	}

	public void setRedirectUri(String redirectUri) {
		this.redirectUri = redirectUri;
	}

	public String getClientId() {
		return clientId;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CacheBean [token=");
		builder.append(token);
		builder.append(", scope=");
		builder.append(scope);
		builder.append(", redirectUri=");
		builder.append(redirectUri);
		builder.append(", clientId=");
		builder.append(clientId);
		builder.append("]");
		return builder.toString();
	}	
}
