package org.gcube.portal.oidc.lr62;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;

public class SessionDestroyAction extends SessionAction {

    protected static final Log log = LogFactoryUtil.getLog(SessionDestroyAction.class);

    @Override
    public void run(HttpSession session) throws ActionException {
        if (log.isTraceEnabled()) {
            log.trace("Session details: id=" + session.getId() + ", instance=" + session);
        }
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        if (configuration.logoutOnPortalLogout()) {
            JWTToken token = JWTTokenUtil.getOIDCFromSession(session);
            if (token != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Performing logout on OIDC server due to session destroy");
                }
                try {
                    List<String> tokenAud = token.getAud();
                    tokenAud.remove(JWTToken.ACCOUNT_RESOURCE);
                    String clientId = tokenAud.iterator().next();
                    if (log.isDebugEnabled()) {
                        log.debug("Performing logout from the client: " + clientId);
                    }
                    OpenIdConnectRESTHelper.logout(token, configuration.getLogoutURL(), clientId);
                } catch (IOException e) {
                    throw new ActionException("Performing logut on OIDC server", e);
                }
            } else {
                log.warn("Cannot find the OIDC token in session");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Don't performing OIDC logout according to configuration");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Removing OIDC tokens from cache proxy");
        }
        User user = (User) session.getAttribute("USER");
        OIDCTokenCacheProxy.getInstance().removeOIDCToken(user, session);
        OIDCTokenCacheProxy.getInstance().removeUMAToken(user, session);
    }

}
