package org.gcube.portal.oidc.lr62;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.oidc.rest.JWTToken;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;

public class PostLoginAction extends Action {

    protected static final Log log = LogFactoryUtil.getLog(PostLoginAction.class);

    @Override
    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        if (log.isInfoEnabled()) {
            log.info("PostLoginAction invoked");
        }
        JWTToken token = JWTTokenUtil.getOIDCFromRequest(request);
        HttpSession session = request.getSession();
        if (token != null && session != null) {
            if (log.isTraceEnabled()) {
                log.trace("Session details: id=" + session.getId() + ", instance=" + session);
            }
            User user = (User) session.getAttribute("USER");
            if (user != null) {
                log.info("Setting OIDC token in proxy");
                OIDCTokenCacheProxy.getInstance().setOIDCToken(user, session, token);
            } else {
                log.error("User object not found in session");
            }
            log.info("Setting OIDC token in session");
            JWTTokenUtil.putOIDCInSession(token, session);
        }
    }

}
